#ifndef CAMERA_H
#define CAMERA_H

#include <string>
#include <sv.synview.h>

#define NUMBER_OF_BUFFERS 10

class CCamera
{
public:
    CCamera();
    ~CCamera();
    void OpenCamera(int iCamera,
                    HWND hDisplayWnd, 
                    LvHSystem hSystem);
    void StartAcquisition();
    void StopAcquisition();
    void CloseCamera();
    bool IsOpen();
    bool IsAcquiring();
    void CallbackNewBuffer(LvHBuffer hBuffer);
    --- %%IF IncRenderModes=1 -----------------------
    void SetRenderType(LvRenderType RenderType);
    LvRenderType GetRenderType();
    void SetScrollbars();
    --- %%ENDIF -------------------------------------
    void Repaint();
    double CalculateFramesPerSecond();
    void UpdateInfoInTitleBar();
    bool ReallocateBuffers();
    --- %%IF IncSimpleImgProcess=1 ------------------
    void SetProcessing(bool bDoProcessing);
    bool GetProcessing();
    --- %%ENDIF -------------------------------------
    --- %%IF IncUniImgPreprocess=1 ------------------
    void SetOptimalUniPixelFormat();
    --- %%ENDIF -------------------------------------

private:
    LvHSystem    m_hSystem;
    LvHInterface m_hInterface;
    LvHDevice    m_hDevice;
    LvHStream    m_hStream;
    LvHRenderer  m_hRenderer;
    LvHEvent     m_hEvent;
    HWND         m_hDisplayWnd;
    --- %%IF IncRenderModes=1 -----------------------
    LvRenderType m_RenderType;
    --- %%ENDIF -------------------------------------
    bool         m_bAcquisitionStarted;
    int32_t      m_iPayloadSize;
    int32_t      m_iCamera;

    --- %%IF CalcFrameRate=1 ------------------------
    uint32_t     m_dwFrameCounter;
    uint32_t     m_dwFrameCounterForFps;
    uint32_t     m_dwGrabStartTimeForFps;
    double       m_dFramesPerSec;
    --- %%ENDIF -------------------------------------
    char         m_szDisplayName[256];
 
    LvHBuffer    m_hBuffers[NUMBER_OF_BUFFERS];
    --- %%IF IncSimpleImgProcess=1 ------------------
    bool         m_bDoProcessing;
    --- %%ENDIF -------------------------------------
};


#endif
