#ifndef _OSDEP_H
#define _OSDEP_H

#ifdef _WIN32
    #include <windows.h>
    #include <sys/stat.h>
    #define OS_CRITICAL_SECTION CRITICAL_SECTION
#else
    #include <sys/stat.h>
    #include <unistd.h>
    #include <dlfcn.h>
    #include <stdio.h>
    #include <assert.h>
    #include <string>
    #define OS_CRITICAL_SECTION pthread_mutex_t
#endif

#include <sv.synview.defs.h>

uint32_t OsGetTickCount();
void OsSleep(uint32_t ms);

void OsInitializeCriticalSection (OS_CRITICAL_SECTION *pCriticalSection);
void OsDeleteCriticalSection (OS_CRITICAL_SECTION *pCriticalSection);
void OsEnterCriticalSection (OS_CRITICAL_SECTION *pCriticalSection);
void OsLeaveCriticalSection (OS_CRITICAL_SECTION *pCriticalSection);

bool OsFileExists(const char *FileName);
bool OsDirExists(const char *FileName);
int OsStricmp(const char *str1, const char *str2);

#endif