#ifndef _CAMERA_H
#define _CAMERA_H

#include <sv.synview.h>

#include <QTextEdit>
#include <QTreeWidget>
#include <QPixmap>
#include <QImage>
#include <QPainter>
#include <QScrollArea>
#include "paint.h"

typedef std::vector<LvHBuffer> CBufferVector; 

class CMainWindow;

class CCamera
{
public:
    CCamera(CMainWindow* MainWindow);
    ~CCamera();
    bool ErrorOccurred(LvStatus Status);
    void ConnectCamera(QScrollArea* pScrollAreaImage);
    void StartAcquisition();
    void StopAcquisition();
    void DisconnectCamera();
    bool IsConnected();
    bool IsAcquiring();
    void CallbackNewBuffer(LvHBuffer hBuffer, void* pBuffer);
    void SetRenderType(LvRenderType RenderType);
    LvRenderType GetRenderType();
    double CalculateFramesPerSecond();
    uint32_t GetFrameCount();
    bool ReallocateBuffers();
    --- %%IF IncSimpleImgProcess=1 -----------
    void SetProcessing(bool bDoProcessing);
    --- %%ENDIF ------------------------------
    --- %%IF IncUniImgPreprocess=1 -----------
    void SetOptimalUniPixelFormat();
    --- %%ENDIF ------------------------------
    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    char* GetChunkDataString();
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------

private:
    LvHSystem     m_hSystem;
    LvHInterface  m_hInterface;
    LvHDevice     m_hDevice;
    LvHStream     m_hStream;
    LvHRenderer   m_hRenderer;
    LvHEvent      m_hNewBufferEvent;
    uint32_t      m_dwFrameCounter;
    uint32_t      m_dwFrameCounterForFps;
    uint32_t      m_dwGrabStartTimeForFps;
    double        m_dFramesPerSec;
    int32_t       m_iPayloadSize;
    LvHBuffer     m_hLastBuffer;
    CBufferVector m_hBufferVector;
    LvRenderType  m_RenderType;
    bool          m_bAcquisitionStarted;
    CMainWindow*  m_pMainWindow;
    QScrollArea*  m_pScrollAreaImage;
    CWidgetPaint* m_pWidgetPaint;
    --- %%IF IncSimpleImgProcess=1 -----------
    bool          m_bDoProcessing;
    --- %%ENDIF ------------------------------
    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    char          m_szChunkLine[256];
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------
};


#endif
