using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using NewElectronicTechnology.SynView; // update the path to NewElectronicTechnology.SynView.dll in References

namespace CsNetSample01
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Panel ControlPanel;
        private System.Windows.Forms.Button ButtonAcquisitionStop;
        private System.Windows.Forms.Button ButtonExit;
        private System.Windows.Forms.Button ButtonAcquisitionStart;
        private System.Windows.Forms.Button ButtonDisconnectCamera;
        private System.Windows.Forms.Button ButtonConnectCamera;
        private System.Windows.Forms.PictureBox PictureBoxLive;
        private System.Windows.Forms.StatusBar StatusBar;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;
        --- %%IF IncSimpleImgProcess=1 ------------
        private CheckBox CheckBoxProcessing;
        --- %%ENDIF -------------------------------
        IntPtr m_hDisplayWindow;
        CCamera m_pCamera;
        LvSystem m_pSystem;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
	        InitializeComponent();
            m_pSystem = null;
            LvLibrary.ThrowErrorEnable = true;
            // The PictureBoxLive refuses to be used from another thread,
            // but the window handle should be safe.
            m_hDisplayWindow = PictureBoxLive.Handle;
            try
            {
                Cursor = Cursors.WaitCursor;
                LvLibrary.OpenLibrary();
                LvSystem.Open("", ref m_pSystem);
                m_pCamera = new CCamera();
                Cursor = Cursors.Default;
                UpdateControls();
            }
            catch (LvException ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                Close();
            }

        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
	          if( disposing )
	          {
                if (m_pCamera != null) m_pCamera.CloseCamera();
                if (m_pSystem != null) LvSystem.Close(ref m_pSystem);
                LvLibrary.CloseLibrary();
                if (components != null) 
		            {
			              components.Dispose();
		            }
	          }
	          base.Dispose( disposing );
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.ControlPanel = new System.Windows.Forms.Panel();
            --- %%IF IncSimpleImgProcess=1 ------------
            this.CheckBoxProcessing = new System.Windows.Forms.CheckBox();
            --- %%ENDIF -------------------------------
            this.ButtonAcquisitionStop = new System.Windows.Forms.Button();
            this.ButtonExit = new System.Windows.Forms.Button();
            this.ButtonAcquisitionStart = new System.Windows.Forms.Button();
            this.ButtonDisconnectCamera = new System.Windows.Forms.Button();
            this.ButtonConnectCamera = new System.Windows.Forms.Button();
            this.PictureBoxLive = new System.Windows.Forms.PictureBox();
            this.StatusBar = new System.Windows.Forms.StatusBar();
            this.ControlPanel.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PictureBoxLive)).BeginInit();
            this.SuspendLayout();
            // 
            // ControlPanel
            // 
            this.ControlPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.ControlPanel.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            --- %%IF IncSimpleImgProcess=1 ------------
            this.ControlPanel.Controls.Add(this.CheckBoxProcessing);
            --- %%ENDIF -------------------------------
            this.ControlPanel.Controls.Add(this.ButtonAcquisitionStop);
            this.ControlPanel.Controls.Add(this.ButtonExit);
            this.ControlPanel.Controls.Add(this.ButtonAcquisitionStart);
            this.ControlPanel.Controls.Add(this.ButtonDisconnectCamera);
            this.ControlPanel.Controls.Add(this.ButtonConnectCamera);
            this.ControlPanel.Location = new System.Drawing.Point(496, 0);
            this.ControlPanel.Name = "ControlPanel";
            this.ControlPanel.Size = new System.Drawing.Size(136, 424);
            this.ControlPanel.TabIndex = 1;
            --- %%IF IncSimpleImgProcess=1 ------------
            //
            // CheckBoxProcessing
            // 
            this.CheckBoxProcessing.AutoSize = true;
            this.CheckBoxProcessing.Location = new System.Drawing.Point(14, 146);
            this.CheckBoxProcessing.Name = "CheckBoxProcessing";
            this.CheckBoxProcessing.Size = new System.Drawing.Size(111, 17);
            this.CheckBoxProcessing.TabIndex = 8;
            this.CheckBoxProcessing.Text = "Simple processing";
            this.CheckBoxProcessing.UseVisualStyleBackColor = true;
            this.CheckBoxProcessing.CheckedChanged += new System.EventHandler(this.CheckBoxProcessing_CheckedChanged);
            --- %%ENDIF -------------------------------
            //
            // ButtonAcquisitionStop
            // 
            this.ButtonAcquisitionStop.Location = new System.Drawing.Point(8, 66);
            this.ButtonAcquisitionStop.Name = "ButtonAcquisitionStop";
            this.ButtonAcquisitionStop.Size = new System.Drawing.Size(120, 23);
            this.ButtonAcquisitionStop.TabIndex = 1;
            this.ButtonAcquisitionStop.Text = "Stop acquisition";
            this.ButtonAcquisitionStop.Click += new System.EventHandler(this.ButtonAcquisitionStop_Click);
            // 
            // ButtonExit
            // 
            this.ButtonExit.Location = new System.Drawing.Point(8, 190);
            this.ButtonExit.Name = "ButtonExit";
            this.ButtonExit.Size = new System.Drawing.Size(120, 23);
            this.ButtonExit.TabIndex = 7;
            this.ButtonExit.Text = "Exit";
            this.ButtonExit.Click += new System.EventHandler(this.ButtonExit_Click);
            // 
            // ButtonAcquisitionStart
            // 
            this.ButtonAcquisitionStart.Location = new System.Drawing.Point(8, 37);
            this.ButtonAcquisitionStart.Name = "ButtonAcquisitionStart";
            this.ButtonAcquisitionStart.Size = new System.Drawing.Size(120, 23);
            this.ButtonAcquisitionStart.TabIndex = 5;
            this.ButtonAcquisitionStart.Text = "Start acquisition";
            this.ButtonAcquisitionStart.Click += new System.EventHandler(this.ButtonAcquisitionStart_Click);
            // 
            // ButtonDisconnectCamera
            // 
            this.ButtonDisconnectCamera.Location = new System.Drawing.Point(9, 95);
            this.ButtonDisconnectCamera.Name = "ButtonDisconnectCamera";
            this.ButtonDisconnectCamera.Size = new System.Drawing.Size(120, 23);
            this.ButtonDisconnectCamera.TabIndex = 2;
            this.ButtonDisconnectCamera.Text = "Disconnect camera";
            this.ButtonDisconnectCamera.Click += new System.EventHandler(this.ButtonDisconnectCamera_Click);
            // 
            // ButtonConnectCamera
            // 
            this.ButtonConnectCamera.Location = new System.Drawing.Point(8, 8);
            this.ButtonConnectCamera.Name = "ButtonConnectCamera";
            this.ButtonConnectCamera.Size = new System.Drawing.Size(120, 23);
            this.ButtonConnectCamera.TabIndex = 0;
            this.ButtonConnectCamera.Text = "Connect camera";
            this.ButtonConnectCamera.Click += new System.EventHandler(this.ButtonConnectCamera_Click);
            // 
            // PictureBoxLive
            // 
            this.PictureBoxLive.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.PictureBoxLive.BackColor = System.Drawing.SystemColors.Control;
            this.PictureBoxLive.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.PictureBoxLive.Location = new System.Drawing.Point(0, 0);
            this.PictureBoxLive.Name = "PictureBoxLive";
            this.PictureBoxLive.Size = new System.Drawing.Size(496, 424);
            this.PictureBoxLive.TabIndex = 2;
            this.PictureBoxLive.TabStop = false;
            this.PictureBoxLive.Paint += new System.Windows.Forms.PaintEventHandler(this.PictureBoxLive_Paint);
            // 
            // StatusBar
            // 
            this.StatusBar.Location = new System.Drawing.Point(0, 424);
            this.StatusBar.Name = "StatusBar";
            this.StatusBar.Size = new System.Drawing.Size(632, 22);
            this.StatusBar.TabIndex = 3;
            this.StatusBar.Text = "-";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(632, 446);
            this.Controls.Add(this.StatusBar);
            this.Controls.Add(this.PictureBoxLive);
            this.Controls.Add(this.ControlPanel);
            this.Name = "Form1";
            this.Text = "Sample application in C# with SynView .Net Class Library";
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.Form1_FormClosing);
            this.ControlPanel.ResumeLayout(false);
            this.ControlPanel.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PictureBoxLive)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() 
        {
	          Application.Run(new Form1());
        }

        private void UpdateControls()
        {
            ButtonConnectCamera.Enabled    = !m_pCamera.IsOpen();
            ButtonDisconnectCamera.Enabled = m_pCamera.IsOpen() && !m_pCamera.IsAcquiring();
            ButtonAcquisitionStart.Enabled = m_pCamera.IsOpen() && !m_pCamera.IsAcquiring();
            ButtonAcquisitionStop.Enabled  = m_pCamera.IsOpen() && m_pCamera.IsAcquiring();
            ButtonExit.Enabled             = !m_pCamera.IsOpen();
            UpdateStatusLine();
        }

        private void UpdateStatusLine()
        {
            if (m_pCamera.IsOpen())
            {
                if (m_pCamera.IsAcquiring())
                    StatusBar.Text = "Camera connected, acquiring";
                else
                    StatusBar.Text = "Camera connected, not acquiring";
            }
            else
                StatusBar.Text = "Camera not connected";
        }

        private void ButtonConnectCamera_Click(object sender, System.EventArgs e)
        {
            Cursor = Cursors.WaitCursor;
            m_pCamera.OpenCamera(m_hDisplayWindow, m_pSystem);
            UpdateControls();
            Cursor = Cursors.Default;
        }

        private void ButtonAcquisitionStart_Click(object sender, System.EventArgs e)
        {
            m_pCamera.StartAcquisition();
            UpdateControls();
        }

        private void ButtonAcquisitionStop_Click(object sender, System.EventArgs e)
        {
            m_pCamera.StopAcquisition();
            UpdateControls();
        }

        private void ButtonDisconnectCamera_Click(object sender, System.EventArgs e)
        {
            m_pCamera.CloseCamera();
            PictureBoxLive.Invalidate();
            UpdateControls();
        }

        private void ButtonExit_Click(object sender, System.EventArgs e)
        {
            m_pCamera.CloseCamera();
            Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            // disable closing if the camera is open
            e.Cancel = m_pCamera.IsOpen();
        }

        private void PictureBoxLive_Paint(object sender, PaintEventArgs e)
        {
            m_pCamera.Repaint();
        }

        --- %%IF IncSimpleImgProcess=1 ------------
        private void CheckBoxProcessing_CheckedChanged(object sender, EventArgs e)
        {
            m_pCamera.SetProcessing(CheckBoxProcessing.Checked);
        }
        --- %%ENDIF -------------------------------
    }
}
