#pragma once

#include "CCamera.h"

namespace CppNetSample01
{
	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
    using namespace NewElectronicTechnology::SynView ;

    /// <summary>
    /// Summary for Form1
    ///
    /// WARNING: If you change the name of this class, you will need to change the
    ///          'Resource File Name' property for the managed resource compiler tool
    ///          associated with all .resx files this class depends on.  Otherwise,
    ///          the designers will not be able to interact properly with localized
    ///          resources associated with this form.
    /// </summary>
    public ref class Form1 : public System::Windows::Forms::Form
    {
    private: 
        IntPtr       m_hDisplayWindow;
        LvSystem^    m_pSystem;
        CCamera^     m_pCamera;
    --- %%IF IncSimpleImgProcess=1 ------------
    private: System::Windows::Forms::CheckBox^  CheckBoxProcessing;
    --- %%ENDIF -------------------------------

    public:
        Form1(void)
        {
            InitializeComponent();
            m_pSystem = nullptr;
            LvLibrary::ThrowErrorEnable = true;
            try 
            {            
                LvLibrary::OpenLibrary();
                LvSystem::Open("", m_pSystem);
                m_pCamera = gcnew CCamera();
                // The PictureBoxLive refuses to be used from another thread,
                // but the window handle should be safe.
                m_hDisplayWindow = PictureBoxLive->Handle;
                UpdateControls();
            }
            catch (LvException^ ex) 
            {
                MessageBox::Show(ex->Message, "Error", MessageBoxButtons::OK, MessageBoxIcon::Exclamation);
                Close();
            }
        }

    protected:
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        ~Form1()
        {
            try 
            {            
                if (m_pCamera != nullptr) delete m_pCamera;
                if (m_pSystem != nullptr) LvSystem::Close(m_pSystem);
                LvLibrary::CloseLibrary();
            }
            catch (LvException^ ex) 
            {
                MessageBox::Show(ex->Message, "Error", MessageBoxButtons::OK, MessageBoxIcon::Exclamation);
            }
            if (components)
            {
                delete components;
            }
        }

    private: System::Windows::Forms::StatusBar^  StatusBar;
    private: System::Windows::Forms::PictureBox^  PictureBoxLive;
    private: System::Windows::Forms::Panel^   ControlPanel;
    private: System::Windows::Forms::Button^  ButtonConnectCamera;
    private: System::Windows::Forms::Button^  ButtonDisconnectCamera;
    private: System::Windows::Forms::Button^  ButtonAcquisitionStart;
    private: System::Windows::Forms::Button^  ButtonAcquisitionStop;
    private: System::Windows::Forms::Button^  ButtonExit;

    private:
        /// <summary>
        /// Required designer variable.
        /// </summary>
        System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        void InitializeComponent(void)
        {
            this->StatusBar = (gcnew System::Windows::Forms::StatusBar());
            this->PictureBoxLive = (gcnew System::Windows::Forms::PictureBox());
            this->ControlPanel = (gcnew System::Windows::Forms::Panel());
            this->ButtonAcquisitionStart = (gcnew System::Windows::Forms::Button());
            this->ButtonExit = (gcnew System::Windows::Forms::Button());
            this->ButtonDisconnectCamera = (gcnew System::Windows::Forms::Button());
            this->ButtonAcquisitionStop = (gcnew System::Windows::Forms::Button());
            this->ButtonConnectCamera = (gcnew System::Windows::Forms::Button());
            --- %%IF IncSimpleImgProcess=1 ------------
            this->CheckBoxProcessing = (gcnew System::Windows::Forms::CheckBox());
            --- %%ENDIF -------------------------------
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->PictureBoxLive))->BeginInit();
            this->ControlPanel->SuspendLayout();
            this->SuspendLayout();
            // 
            // StatusBar
            // 
            this->StatusBar->Location = System::Drawing::Point(0, 446);
            this->StatusBar->Name = L"StatusBar";
            this->StatusBar->Size = System::Drawing::Size(689, 22);
            this->StatusBar->TabIndex = 5;
            this->StatusBar->Text = L"-";
            // 
            // PictureBoxLive
            // 
            this->PictureBoxLive->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
                | System::Windows::Forms::AnchorStyles::Left) 
                | System::Windows::Forms::AnchorStyles::Right));
            this->PictureBoxLive->BackColor = System::Drawing::SystemColors::Control;
            this->PictureBoxLive->Location = System::Drawing::Point(0, 0);
            this->PictureBoxLive->Name = L"PictureBoxLive";
            this->PictureBoxLive->Size = System::Drawing::Size(552, 446);
            this->PictureBoxLive->TabIndex = 4;
            this->PictureBoxLive->TabStop = false;
            this->PictureBoxLive->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Form1::PictureBoxLive_Paint);
            // 
            // ControlPanel
            // 
            this->ControlPanel->Anchor = static_cast<System::Windows::Forms::AnchorStyles>(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
                | System::Windows::Forms::AnchorStyles::Right));
            this->ControlPanel->BorderStyle = System::Windows::Forms::BorderStyle::Fixed3D;
            --- %%IF IncSimpleImgProcess=1 ------------
            this->ControlPanel->Controls->Add(this->CheckBoxProcessing);
            --- %%ENDIF -------------------------------
            this->ControlPanel->Controls->Add(this->ButtonAcquisitionStart);
            this->ControlPanel->Controls->Add(this->ButtonExit);
            this->ControlPanel->Controls->Add(this->ButtonDisconnectCamera);
            this->ControlPanel->Controls->Add(this->ButtonAcquisitionStop);
            this->ControlPanel->Controls->Add(this->ButtonConnectCamera);
            this->ControlPanel->Location = System::Drawing::Point(552, 0);
            this->ControlPanel->Name = L"ControlPanel";
            this->ControlPanel->Size = System::Drawing::Size(136, 446);
            this->ControlPanel->TabIndex = 3;
            // 
            // ButtonAcquisitionStart
            // 
            this->ButtonAcquisitionStart->Location = System::Drawing::Point(9, 45);
            this->ButtonAcquisitionStart->Name = L"ButtonAcquisitionStart";
            this->ButtonAcquisitionStart->Size = System::Drawing::Size(120, 23);
            this->ButtonAcquisitionStart->TabIndex = 1;
            this->ButtonAcquisitionStart->Text = L"Start acquisition";
            this->ButtonAcquisitionStart->Click += gcnew System::EventHandler(this, &Form1::ButtonAcquisitionStart_Click);
            // 
            // ButtonExit
            // 
            this->ButtonExit->Location = System::Drawing::Point(8, 204);
            this->ButtonExit->Name = L"ButtonExit";
            this->ButtonExit->Size = System::Drawing::Size(120, 23);
            this->ButtonExit->TabIndex = 7;
            this->ButtonExit->Text = L"Exit";
            this->ButtonExit->Click += gcnew System::EventHandler(this, &Form1::ButtonExit_Click);
            // 
            // ButtonDisconnectCamera
            // 
            this->ButtonDisconnectCamera->Location = System::Drawing::Point(9, 103);
            this->ButtonDisconnectCamera->Name = L"ButtonDisconnectCamera";
            this->ButtonDisconnectCamera->Size = System::Drawing::Size(120, 23);
            this->ButtonDisconnectCamera->TabIndex = 5;
            this->ButtonDisconnectCamera->Text = L"Disconnect camera";
            this->ButtonDisconnectCamera->Click += gcnew System::EventHandler(this, &Form1::ButtonDisconnectCamera_Click);
            // 
            // ButtonAcquisitionStop
            // 
            this->ButtonAcquisitionStop->Location = System::Drawing::Point(9, 74);
            this->ButtonAcquisitionStop->Name = L"ButtonAcquisitionStop";
            this->ButtonAcquisitionStop->Size = System::Drawing::Size(120, 23);
            this->ButtonAcquisitionStop->TabIndex = 2;
            this->ButtonAcquisitionStop->Text = L"Stop acquisition";
            this->ButtonAcquisitionStop->Click += gcnew System::EventHandler(this, &Form1::ButtonAcquisitionStop_Click);
            // 
            // ButtonConnectCamera
            // 
            this->ButtonConnectCamera->Location = System::Drawing::Point(8, 16);
            this->ButtonConnectCamera->Name = L"ButtonConnectCamera";
            this->ButtonConnectCamera->Size = System::Drawing::Size(120, 23);
            this->ButtonConnectCamera->TabIndex = 0;
            this->ButtonConnectCamera->Text = L"Connect camera";
            this->ButtonConnectCamera->Click += gcnew System::EventHandler(this, &Form1::ButtonConnectCamera_Click);
            --- %%IF IncSimpleImgProcess=1 ------------
            //
            // CheckBoxProcessing
            // 
            this->CheckBoxProcessing->AutoSize = true;
            this->CheckBoxProcessing->Location = System::Drawing::Point(12, 143);
            this->CheckBoxProcessing->Name = L"CheckBoxProcessing";
            this->CheckBoxProcessing->Size = System::Drawing::Size(111, 17);
            this->CheckBoxProcessing->TabIndex = 8;
            this->CheckBoxProcessing->Text = L"Simple processing";
            this->CheckBoxProcessing->UseVisualStyleBackColor = true;
            this->CheckBoxProcessing->CheckedChanged += gcnew System::EventHandler(this, &Form1::CheckBoxProcessing_CheckedChanged);
            --- %%ENDIF -------------------------------
            //
            // Form1
            // 
            this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->ClientSize = System::Drawing::Size(689, 468);
            this->Controls->Add(this->StatusBar);
            this->Controls->Add(this->PictureBoxLive);
            this->Controls->Add(this->ControlPanel);
            this->Name = L"Form1";
            this->Text = L"Sample application in C++ with SynView .Net Class Library";
            this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &Form1::Form1_FormClosing);
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->PictureBoxLive))->EndInit();
            this->ControlPanel->ResumeLayout(false);
            this->ControlPanel->PerformLayout();
            this->ResumeLayout(false);

        }
#pragma endregion

        private: System::Void UpdateStatusLine()
        {
            if (m_pCamera->IsOpen())
            {
                if (m_pCamera->IsAcquiring())
                    StatusBar->Text = "Camera connected, acquiring"; 
                else
                    StatusBar->Text = "Camera connected, not acquiring"; 
            }
            else
                StatusBar->Text = "Camera not connected"; 
        }

        private: System::Void UpdateControls()
        {
            ButtonConnectCamera->Enabled    = !m_pCamera->IsOpen();
            ButtonDisconnectCamera->Enabled = m_pCamera->IsOpen() && !m_pCamera->IsAcquiring();
            ButtonAcquisitionStart->Enabled = m_pCamera->IsOpen() && !m_pCamera->IsAcquiring();
            ButtonAcquisitionStop->Enabled  = m_pCamera->IsOpen() && m_pCamera->IsAcquiring();
            ButtonExit->Enabled             = !m_pCamera->IsOpen();
            UpdateStatusLine();
        }

        private: System::Void ButtonConnectCamera_Click(System::Object^  sender, System::EventArgs^ e) 
        {
            Cursor = Cursors::WaitCursor;
            m_pCamera->OpenCamera(m_hDisplayWindow, m_pSystem);
            UpdateControls();
            Cursor = Cursors::Default;
        }
        
        private: System::Void ButtonDisconnectCamera_Click(System::Object^  sender, System::EventArgs^ e) 
        {
            m_pCamera->CloseCamera();
            PictureBoxLive->Invalidate();
            UpdateControls();
        }

        private: System::Void ButtonAcquisitionStart_Click(System::Object^  sender, System::EventArgs^ e) 
        {
            m_pCamera->StartAcquisition();
            UpdateControls();
        }

        private: System::Void ButtonAcquisitionStop_Click(System::Object^  sender, System::EventArgs^ e) 
        {
            m_pCamera->StopAcquisition();
            UpdateControls();
        }

        private: System::Void ButtonExit_Click(System::Object^  sender, System::EventArgs^ e) 
        {
            m_pCamera->CloseCamera();
            Close();
        }

        private: System::Void Form1_FormClosing(System::Object^  sender, System::Windows::Forms::FormClosingEventArgs^  e) 
        {
            // disable closing if the camera is open
            e->Cancel = m_pCamera->IsOpen();
        }

        private: System::Void PictureBoxLive_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e) 
        {
            m_pCamera->Repaint();
        }
        --- %%IF IncSimpleImgProcess=1 ------------

        private: System::Void CheckBoxProcessing_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
        {
            m_pCamera->SetProcessing(CheckBoxProcessing->Checked);
        }
        --- %%ENDIF -------------------------------
};
}

