#pragma once

#define NUMBER_OF_BUFFERS %%Buffers%%

// the assembly is in single file
#ifdef _WIN64
    #using <NewElectronicTechnology.SynView.40.x64.dll>
#else
    #using <NewElectronicTechnology.SynView.40.dll>
#endif

namespace CppNetSample01
{
    using namespace System;
    using namespace NewElectronicTechnology::SynView ;

    //=============================================================================
    // The CCamera class implements access to one camera. In this simple sample
    // it is not necessary; we could use global variables and functions instead.
    // However, the CCamera class becomes practical when working with multiple 
    // cameras (not demonstrated in this sample).

    #define NUMBER_OF_BUFFERS 10

    public ref class CCamera
    {
    public:
        CCamera();
        ~CCamera();
        void OpenCamera(IntPtr hDisplayWnd, LvSystem^ pSystem);
        void CloseCamera();
        void StartAcquisition();
        void StopAcquisition();
        --- %%IF IncSimpleImgProcess=1 ------------------
        void SetProcessing(bool bDoProcessing);
        --- %%ENDIF -------------------------------------
        bool IsOpen();
        bool IsAcquiring();
        --- %%IF IncUniImgPreprocess=1 ------------------
        void SetOptimalUniPixelFormat();
        --- %%ENDIF -------------------------------------
        void Repaint();
        void NewBufferEventHandler(System::Object^ sender, LvNewBufferEventArgs^ e);

    private:
        LvSystem^         m_pSystem;
        LvInterface^      m_pInterface;
        LvDevice^         m_pDevice;
        LvStream^         m_pStream;
        LvRenderer^       m_pRenderer;
        array<LvBuffer^>^ m_Buffers;
        IntPtr            m_hDisplayWnd;
        LvEvent^          m_pEvent;
        --- %%IF IncSimpleImgProcess=1 ------------------
        bool              m_bDoProcessing;
        --- %%ENDIF -------------------------------------
    };
}
