#include "stdafx.h"
#include "CCamera.h"

#define TRY           try {
#define CATCH         } catch (LvException^ ex) {MessageBox::Show(ex->Message, "Error", MessageBoxButtons::OK, MessageBoxIcon::Exclamation);}
#define CATCH_NO_MSG  } catch (LvException^) {}


namespace CppNetSample01
{
    using namespace NewElectronicTechnology::SynView ;
    using namespace System;
    using namespace System::Threading;
    using namespace System::Windows::Forms; 
    //-----------------------------------------------------------------------------
    // CCamera constructor

    CCamera::CCamera()
    {
        m_pSystem     = nullptr;
        m_pInterface  = nullptr;
        m_pDevice     = nullptr;
        m_pStream     = nullptr;
        m_pRenderer   = nullptr;
        m_hDisplayWnd = IntPtr(0);
        m_pEvent      = nullptr;
        m_Buffers = gcnew array<LvBuffer^>(NUMBER_OF_BUFFERS); 
        for (int i=0; i<NUMBER_OF_BUFFERS; i++)
            m_Buffers[i] = nullptr;
        --- %%IF IncSimpleImgProcess=1 ------------------
        m_bDoProcessing = false;
        --- %%ENDIF -------------------------------------
    }

    //-----------------------------------------------------------------------------
    // CCamera destructor

    CCamera::~CCamera()
    {
        TRY
            if (m_pDevice != nullptr) CloseCamera();
        CATCH
    }

    //-----------------------------------------------------------------------------

    void CCamera::OpenCamera(IntPtr hDisplayWnd, LvSystem^ pSystem)
    {
        TRY
            if (m_pDevice != nullptr) CloseCamera(); 
            m_pSystem = pSystem;
            m_hDisplayWnd = hDisplayWnd;

            LvInterface^ pInterface = nullptr;
            LvDevice^ pDevice = nullptr;
            pSystem->UpdateInterfaceList();
            --- %%IF OpenInterface=ByInterfaceId -------
            pSystem->OpenInterface("%%INTERFACE_ID%%", pInterface);
            --- %%ENDIF --------------------------------
            --- %%IF OpenInterface=ByInterfaceTlType ---
            String^ InterfaceId;
            pSystem->FindInterface(LvFindBy::TLType, "%%INTERFACE_TLTYPE%%", InterfaceId);
            pSystem->OpenInterface(InterfaceId, pInterface);
            --- %%ENDIF --------------------------------

            pInterface->UpdateDeviceList();
            --- %%IF OpenDevice=ByDeviceId -------------
            pInterface->OpenDevice("%%DEVICE_ID%%", pDevice, LvDeviceAccess::Control);
            --- %%ENDIF --------------------------------
            --- %%IF OpenDevice=ByDeviceModelName ------
            String^ DeviceId;
            pInterface->FindDevice(LvFindBy::ModelName, "%%DEVICE_MODELNAME%%", DeviceId);
            pInterface->OpenDevice(DeviceId, pDevice, LvDeviceAccess::Control);
            --- %%ENDIF --------------------------------
            --- %%IF OpenDevice=ByDeviceIpAddress ------
            String^ DeviceId;
            pInterface->FindDevice(LvFindBy::GevIPAddress, "%%DEVICE_IPADDRESS%%", DeviceId);
            pInterface->OpenDevice(DeviceId, pDevice, LvDeviceAccess::Control);
            --- %%ENDIF --------------------------------
            --- %%IF OpenDevice=ByDeviceUserId ---------
            String^ DeviceId;
            pInterface->FindDevice(LvFindBy::UserID, "%%DEVICE_USERID%%", DeviceId);
            pInterface->OpenDevice(DeviceId, pDevice, LvDeviceAccess::Control);
            --- %%ENDIF --------------------------------
            --- %%IF Sys.AutoLoadedCfg=1 ---------------
            // Note: When the code was generated, in SynView Explorer was switched ON the option
            // to autoload the camera settings after opening the camera. For this reason the following
            // line loads the camera settings from the file to assure the same starting status.
            --- %%ENDIF --------------------------------
            --- %%IF Sys.SnippetFile=1 -----------------
            pDevice->LoadSettings("", "%%Sys.CameraCfgFile%%", (unsigned int) LvSaveFlag::All);
            --- %%ENDIF --------------------------------

            --- %%IF Snippet=All ---------------------
            // The #error line below is intentionally inserted to the code in case you
            // generate the code from streamable or all writable features.
            #error Review the feature settings code and remove the unnecessary items!
            // Before removing this line from the code, go carefully through all the feature
            // settings below and leave there only those, which really need to be set.

            --- %%ENDIF ------------------------------
            --- %%IF Snippet=Streamable --------------
            // The #error line below is intentionally inserted to the code in case you
            // generate the code from streamable or all writable features.
            #error Review the feature settings code and remove the unnecessary items!
            // Before removing this line from the code, go carefully through all the feature
            // settings below and leave there only those, which really need to be set.

            --- %%ENDIF ------------------------------
            %%CameraRemoteFeaturesCode%%

            m_pInterface = pInterface;
            m_pDevice = pDevice;

            --- %%IF IncUniImgPreprocess=1 -------------
            m_pDevice->SetEnum(LvDeviceFtr::LvUniProcessMode, (int)LvUniProcessMode::Auto);
            SetOptimalUniPixelFormat();

            --- %%ENDIF --------------------------------
            m_pDevice->OpenStream("", m_pStream);
            m_pStream->OpenEvent(LvEventType::NewBuffer, m_pEvent);     
            for (int i=0; i<NUMBER_OF_BUFFERS; i++)
                m_pStream->OpenBuffer(IntPtr(0), 0, IntPtr(0), 0, m_Buffers[i]); 
            m_pStream->SetInt32(LvStreamFtr::LvPostponeQueueBuffers, 3);
            m_pStream->OpenRenderer(m_pRenderer);                      
            m_pRenderer->SetWindow(m_hDisplayWnd);                     

            m_pEvent->OnEventNewBuffer += gcnew LvEventNewBufferHandler(this, &CCamera::NewBufferEventHandler); 
            m_pEvent->SetCallbackNewBuffer(true, IntPtr(0));      
            m_pEvent->StartThread();                                   
        CATCH
    }

    //-----------------------------------------------------------------------------
    // Starts acquisition

    void CCamera::StartAcquisition()
    {
        TRY
            m_pStream->FlushQueue(LvQueueOperation::AllToInput);
            if (m_pDevice == nullptr) return;
            m_pDevice->AcquisitionStart();                             
        CATCH
    }

    //-----------------------------------------------------------------------------
    // Stops acquisition

    void CCamera::StopAcquisition()
    {
        TRY
            if (m_pStream == nullptr) return;
            m_pDevice->AcquisitionStop();          
        CATCH
    }

    //-----------------------------------------------------------------------------
    // Closes the cameras

    void CCamera::CloseCamera()
    {
        TRY
            if (m_pDevice == nullptr) return;
            if (IsAcquiring()) StopAcquisition();
            m_pEvent->StopThread();                
            m_pEvent->SetCallbackNewBuffer(false, IntPtr(0));      
            m_pStream->CloseEvent(m_pEvent);       
            m_pStream->CloseRenderer(m_pRenderer);
            m_pStream->FlushQueue(LvQueueOperation::AllDiscard);
            for (int i=0; i<NUMBER_OF_BUFFERS; i++)
                if (m_Buffers[i] != nullptr)
                    m_pStream->CloseBuffer(m_Buffers[i]);
            m_pDevice->CloseStream(m_pStream);     
            m_pInterface->CloseDevice(m_pDevice); 
            m_pSystem->CloseInterface(m_pInterface); 
        CATCH
    }

    //-----------------------------------------------------------------------------
    // Utility function for enabling/disabling buttons

    bool CCamera::IsOpen()
    {
        return m_pDevice != nullptr;
    }

    //-----------------------------------------------------------------------------
    // Utility function for enabling/disabling buttons

    bool CCamera::IsAcquiring()
    {
        TRY
            if (m_pDevice == nullptr) return false;
            Boolean iIsAcquiring;
            m_pDevice->GetBool(LvDeviceFtr::LvDeviceIsAcquiring, iIsAcquiring);
            return iIsAcquiring;
        CATCH_NO_MSG
    }

    --- %%IF IncSimpleImgProcess=1 ------------------
    //-----------------------------------------------------------------------------
    // Switches ON/OFF image processing done in the callback

    void CCamera::SetProcessing(bool bDoProcessing)
    {
        m_bDoProcessing = bDoProcessing;
    }

    --- %%ENDIF -------------------------------------
    --- %%IF IncUniImgPreprocess=1 ------------------
    //-----------------------------------------------------------------------------
    // Determines optimal pixel format for the uni-process

    void CCamera::SetOptimalUniPixelFormat()
    {
        TRY
            UInt32 PixelFormat;
            m_pDevice->GetEnum(LvDeviceFtr::PixelFormat, PixelFormat);
            UInt32 UniPixelFormat = PixelFormat;
            switch (PixelFormat)
            {
                case LvPixelFormat::Mono8:
                case LvPixelFormat::Mono10:
                case LvPixelFormat::Mono12:
                case LvPixelFormat::Mono16:
                    UniPixelFormat = (UInt32)LvPixelFormat::Mono8;
                    break;

                case LvPixelFormat::BayerGR8:
                case LvPixelFormat::BayerRG8:
                case LvPixelFormat::BayerGB8:
                case LvPixelFormat::BayerBG8:
                case LvPixelFormat::BayerGR10:
                case LvPixelFormat::BayerRG10:
                case LvPixelFormat::BayerGB10:
                case LvPixelFormat::BayerBG10:
                case LvPixelFormat::BayerGR12:
                case LvPixelFormat::BayerRG12:
                case LvPixelFormat::BayerGB12:
                case LvPixelFormat::BayerBG12:
                case LvPixelFormat::RGB8Packed:
                case LvPixelFormat::RGBA8Packed:
                    UniPixelFormat = (UInt32)LvPixelFormat::BGRA8Packed;
                    break;
            }
            m_pDevice->SetEnum(LvDeviceFtr::LvUniPixelFormat, UniPixelFormat);
        CATCH
    }

    --- %%ENDIF -------------------------------------
    //-----------------------------------------------------------------------------

    void CCamera::Repaint()
    {
        TRY
            if (m_pRenderer != nullptr)
                m_pRenderer->Repaint();
        CATCH_NO_MSG
    }

    //-----------------------------------------------------------------------------

    void CCamera::NewBufferEventHandler(System::Object^ sender, LvNewBufferEventArgs^ e)
    {
        TRY
            if (e->Buffer == nullptr) return;

            --- %%IF IncSimpleImgProcess=1 ------------------
            // in C++ we can easily mix managed and unmanaged code
            IntPtr pData;
            Int64 iImageOffset = 0;
            --- %%IF IncUniImgPreprocess=1 ------------------
            e->Buffer->GetPtr(LvBufferFtr::UniBase, pData);
            e->Buffer->GetInt(LvBufferFtr::UniImageOffset, iImageOffset);
            --- %%ELSE --------------------------------------
            e->Buffer->GetPtr(LvBufferFtr::Base, pData);
            e->Buffer->GetInt(LvBufferFtr::ImageOffset, iImageOffset);
            --- %%ENDIF -------------------------------------
            pData = (IntPtr)(pData.ToInt64() + iImageOffset);
            if (m_bDoProcessing && pData.ToPointer() != nullptr)
            {
                // we will do some easy processing - invert the pixel values in an area
                Int32 iWidth;
                Int32 iHeight;
                Int32 iLinePitch;
                UInt32 iPixelFormat;    // LvPixelFormat enumeration value
                m_pDevice->GetInt32(LvDeviceFtr::Width, iWidth);
                m_pDevice->GetInt32(LvDeviceFtr::Height, iHeight);
                --- %%IF IncUniImgPreprocess=1 ------------------
                m_pDevice->GetEnum(LvDeviceFtr::LvUniPixelFormat, iPixelFormat);
                m_pDevice->GetInt32(LvDeviceFtr::LvUniLinePitch, iLinePitch);
                Int32 iBytesPerPixel = ((iPixelFormat & 0x00FF0000) >> 16) / 8;
                --- %%ELSE --------------------------------------
                m_pDevice->GetEnum(LvDeviceFtr::PixelFormat, iPixelFormat);
                Int32 iBitsPerPixel = (iPixelFormat & 0x00FF0000) >> 16;
                iLinePitch = ((iWidth * iBitsPerPixel)+7)/8;
                Int32 iBytesPerPixel = iBitsPerPixel / 8;
                --- %%ENDIF -------------------------------------

                for (Int32 j=0; j<(iHeight/2); j++)
                {
                    Byte* pPixel = ((Byte*)pData.ToPointer()) + (iHeight/4 + j)*iLinePitch + (iWidth/4)*iBytesPerPixel;
                    for (Int32 i=0; i<(iWidth/2); i++)
                    {
                        for (Int32 k=0; k<iBytesPerPixel; k++)
                        {
                            *pPixel = ~*pPixel;
                            pPixel++;
                        }
                    }
                }
            }
            --- %%ELSE --------------------------------------
            // no image processing demonstrated - switch it ON in the code generation Wizard if you need it
            --- %%ENDIF -------------------------------------

            m_pRenderer->DisplayImage(e->Buffer);
            e->Buffer->Queue();
        CATCH_NO_MSG
    }

    //-----------------------------------------------------------------------------

}
