#ifndef CAMERA_H
#define CAMERA_H

#include <sv.synview.class.h>

#define NUMBER_OF_BUFFERS 10

class CCamera
{
public:
    CCamera();
    ~CCamera();
    void OpenCamera(int iCamera,
                    HWND hDisplayWnd, 
                    LvSystem* pSystem);
    void StartAcquisition();
    void StopAcquisition();
    void CloseCamera();
    bool IsOpen();
    bool IsAcquiring();
    void CallbackNewBuffer(LvBuffer* pBuffer);
    --- %%IF IncRenderModes=1 -----------------------
    void SetRenderType(LvRenderType RenderType);
    LvRenderType GetRenderType();
    void SetScrollbars();
    --- %%ENDIF -------------------------------------
    void Repaint();
    double CalculateFramesPerSecond();
    void UpdateInfoInTitleBar();
    bool ReallocateBuffers();
    --- %%IF IncSimpleImgProcess=1 ------------------
    void SetProcessing(bool bDoProcessing);
    bool GetProcessing();
    --- %%ENDIF -------------------------------------
    --- %%IF IncUniImgPreprocess=1 ------------------
    void SetOptimalUniPixelFormat();
    --- %%ENDIF -------------------------------------

private:
    LvSystem*    m_pSystem;
    LvInterface* m_pInterface;
    LvDevice*    m_pDevice;
    LvStream*    m_pStream;
    LvRenderer*  m_pRenderer;
    LvEvent*     m_pEvent;
    HWND         m_hDisplayWnd;
    --- %%IF IncRenderModes=1 -----------------------
    LvRenderType m_RenderType;
    --- %%ENDIF -------------------------------------
    bool         m_bAcquisitionStarted;
    int32_t      m_iPayloadSize;
    int32_t      m_iCamera;

    --- %%IF CalcFrameRate=1 ------------------------
    uint32_t     m_dwFrameCounter;
    uint32_t     m_dwFrameCounterForFps;
    uint32_t     m_dwGrabStartTimeForFps;
    double       m_dFramesPerSec;
    --- %%ENDIF -------------------------------------
    std::string  m_sDisplayName;
 
    LvBuffer*    m_Buffers[NUMBER_OF_BUFFERS];
    --- %%IF IncSimpleImgProcess=1 ------------------
    bool         m_bDoProcessing;
    --- %%ENDIF -------------------------------------
};


#endif
