#define _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_DEPRECATE

#include <QMessageBox>

#include "camera.h"
#include "mainwindow.h"
#include "osdep.h"

bool g_bUseOwnBuffers   = false;
int  g_iNumberOfBuffers = %%Buffers%%;
int  g_iNumberOfTiles   = 6;

//-----------------------------------------------------------------------------
// The callback function

void LV_STDC CallbackNewBufferFunction(LvHBuffer /*hBuffer*/,
                                       void* pUserPointer,
                                       void* pUserParam)
{
    CCamera* pCamera = (CCamera*) pUserParam;
    // in UserPointer we hold pointer to buffer
    pCamera->CallbackNewBuffer((LvBuffer*) pUserPointer);
}

//-----------------------------------------------------------------------------

CCamera::CCamera(CMainWindow* MainWindow)
{
    m_pMainWindow           = MainWindow;
    m_pSystem               = NULL;
    m_pInterface            = NULL;
    m_pDevice               = NULL;
    m_pStream               = NULL;
    m_pRenderer             = NULL;
    m_pNewBufferEvent       = NULL;
    m_RenderType            = LvRenderType_FullSize;
    m_bAcquisitionStarted   = false;
    m_dwGrabStartTimeForFps = OsGetTickCount();
    m_dwFrameCounterForFps  = 0;
    m_dwFrameCounter        = 0;
    m_dFramesPerSec         = 0;
    m_iPayloadSize          = 0;
    m_pLastBuffer           = NULL;
    --- %%IF IncSimpleImgProcess=1 -----------
    m_bDoProcessing         = false;
    --- %%ENDIF ------------------------------
    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    memset(m_szChunkLine, 0, sizeof(m_szChunkLine));
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------
    LvStatus SynViewStatus;
    SynViewStatus = LvSystem::Open("", m_pSystem);
    if (ErrorOccurred(SynViewStatus)) return;
}

//-----------------------------------------------------------------------------

CCamera::~CCamera()
{
    if (m_pDevice != NULL) DisconnectCamera();
    LvSystem::Close(m_pSystem);
}

//-----------------------------------------------------------------------------
// Error check with a message box displayed, when it is an error

bool CCamera::ErrorOccurred(LvStatus ErrorStatus)
{
    if (ErrorStatus == LVSTATUS_OK) return false;
    char szMessage[512];
    LvGetErrorMessage(ErrorStatus, szMessage, sizeof(szMessage));
    QMessageBox::critical(m_pMainWindow, "Error", szMessage);
    return true;
}

//-----------------------------------------------------------------------------

void CCamera::ConnectCamera(QScrollArea* pScrollAreaImage)
{
    if (m_pDevice != NULL) DisconnectCamera();
    m_pScrollAreaImage = pScrollAreaImage; 
    %%REM The SynViewStatus is used instead of ErrorStatus, because the SynViewGen inserts ErrorStatus in CameraRemoteFeaturesCode
    LvStatus SynViewStatus;
    LvInterface* pInterface;
    LvDevice* pDevice;
    m_pSystem->UpdateInterfaceList();
    --- %%IF OpenInterface=ByInterfaceId -----
    SynViewStatus = m_pSystem->OpenInterface("%%INTERFACE_ID%%", pInterface);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenInterface=ByInterfaceTlType -
    char InterfaceId[256];
    SynViewStatus = m_pSystem->FindInterface(LvFindBy_TLType, "%%INTERFACE_TLTYPE%%", InterfaceId, sizeof(InterfaceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pSystem->OpenInterface(InterfaceId, pInterface);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------

    pInterface->UpdateDeviceList();
    --- %%IF OpenDevice=ByDeviceId -----------
    SynViewStatus = pInterface->OpenDevice("%%DEVICE_ID%%", pDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenDevice=ByDeviceModelName ----
    char DeviceId[256];
    SynViewStatus = pInterface->FindDevice(LvFindBy_ModelName, "%%DEVICE_MODELNAME%%", DeviceId, sizeof(DeviceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = pInterface->OpenDevice(DeviceId, pDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenDevice=ByDeviceIpAddress ----
    char DeviceId[256];
    SynViewStatus = pInterface->FindDevice(LvFindBy_GevIPAddress, "%%DEVICE_IPADDRESS%%", DeviceId, sizeof(DeviceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = pInterface->OpenDevice(DeviceId, pDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenDevice=ByDeviceUserId -------
    char DeviceId[256];
    SynViewStatus = pInterface->FindDevice(LvFindBy_UserID, "%%DEVICE_USERID%%", DeviceId, sizeof(DeviceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = pInterface->OpenDevice(DeviceId, pDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF Sys.AutoLoadedCfg=1 -------------
    // Note: When the code was generated, in SynView Explorer was switched ON the option
    // to autoload the camera settings after opening the camera. For this reason the following
    // line loads the camera settings from the file to assure the same starting status.
    --- %%ENDIF ------------------------------
    --- %%IF Sys.SnippetFile=1 ---------------
    SynViewStatus = pDevice->LoadSettings("", "%%Sys.CameraCfgFile%%", LvSaveFlag_All);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------

    --- %%IF Snippet=All ---------------------
    // The #error line below is intentionally inserted to the code in case you
    // generate the code from streamable or all writable features.
    #error Review the feature settings code and remove the unnecessary items!
    // Before removing this line from the code, go carefully through all the feature
    // settings below and leave there only those, which really need to be set.

    --- %%ENDIF ------------------------------
    --- %%IF Snippet=Streamable --------------
    // The #error line below is intentionally inserted to the code in case you
    // generate the code from streamable or all writable features.
    #error Review the feature settings code and remove the unnecessary items!
    // Before removing this line from the code, go carefully through all the feature
    // settings below and leave there only those, which really need to be set.

    --- %%ENDIF ------------------------------
    %%CameraRemoteFeaturesCode%%

    m_pInterface = pInterface;
    m_pDevice = pDevice;

    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkModeActive, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%IF CHUNK_ENABLED OffsetX ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_OffsetX);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED OffsetY ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_OffsetY);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Width ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_Width);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Height ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_Height);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED PixelFormat ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_PixelFormat);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LinePitch ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_LinePitch);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED FrameID ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_FrameID);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Timestamp ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_Timestamp);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED ExposureTime ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_ExposureTime);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Gain ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_Gain);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LineStatusAll ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_LineStatusAll);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LvExternalADCValue ---
    SynViewStatus = m_pDevice->SetEnum (LvDevice_ChunkSelector, LvChunkSelector_LvExternalADCValue);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->SetBool(LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------

    --- %%IF IncUniImgPreprocess=1 -----------
    SynViewStatus = m_pDevice->SetEnum(LvDevice_LvUniProcessMode, LvUniProcessMode_Auto);
    if (ErrorOccurred(SynViewStatus)) return;
    SetOptimalUniPixelFormat();
    --- %%ENDIF ------------------------------
    SynViewStatus = m_pDevice->OpenStream("", m_pStream);
    if (ErrorOccurred(SynViewStatus)) return;

    SynViewStatus = m_pStream->OpenEvent(LvEventType_NewBuffer, m_pNewBufferEvent);
    if (ErrorOccurred(SynViewStatus)) return;
    if (!ReallocateBuffers()) return;
    
    SynViewStatus = m_pStream->OpenRenderer(m_pRenderer);
    if (ErrorOccurred(SynViewStatus)) return;
    #ifdef _WIN32
        SynViewStatus = m_pRenderer->SetEnum(LvRenderer_LvRenderType, LvRenderType_ScaleToTiles);
        if (ErrorOccurred(SynViewStatus)) return;
        SynViewStatus = m_pRenderer->SetInt32(LvRenderer_LvNumberOfTiles, g_iNumberOfTiles);
        if (ErrorOccurred(SynViewStatus)) return;
        SynViewStatus = m_pRenderer->SetEnum(LvRenderer_LvRenderType, LvRenderType_FullSize);
        if (ErrorOccurred(SynViewStatus)) return;
    #endif
   
    // To be able to display all tiles, we need to delay the return of the buffers
    // to the input buffer pool
    SynViewStatus = m_pStream->SetInt32(LvStream_LvPostponeQueueBuffers, g_iNumberOfTiles);
    if (ErrorOccurred(SynViewStatus)) return;

    SynViewStatus = m_pNewBufferEvent->SetCallbackNewBuffer(CallbackNewBufferFunction, this);
    if (ErrorOccurred(SynViewStatus)) return;

    m_pWidgetPaint = new CWidgetPaint();
    m_pWidgetPaint->SetRenderer(m_pRenderer);
    m_pScrollAreaImage->setWidget(m_pWidgetPaint);
}

//-----------------------------------------------------------------------------
// Reallocates the buffers, if the payload size changes

bool CCamera::ReallocateBuffers()
{
    LvStatus SynViewStatus;
    int iPayloadSize;
    SynViewStatus = m_pStream->GetInt32(LvStream_LvCalcPayloadSize, &iPayloadSize);
    if (ErrorOccurred(SynViewStatus)) return false;
    if (iPayloadSize != m_iPayloadSize)
    {
        // buffers are either not yet allocated, or something has changed, so there is a need to reallocate
        m_pStream->FlushQueue(LvQueueOperation_AllDiscard);
        for (int i=0; i<(int)m_pBufferVector.size(); i++)
        {
            LvBuffer* pBuffer = m_pBufferVector[i];
            if (g_bUseOwnBuffers)
            {
                void* pDataPointer = NULL;
                pBuffer->GetPtr (LvBuffer_Base, &pDataPointer);
                if (pDataPointer != NULL) free(pDataPointer);
            }
            SynViewStatus = m_pStream->CloseBuffer(pBuffer);
            if (ErrorOccurred(SynViewStatus)) return false;
        }
        m_pBufferVector.clear();
        m_iPayloadSize = iPayloadSize;
        for (int i=0; i<g_iNumberOfBuffers; i++) 
        {
            LvBuffer* pBuffer;
            if (g_bUseOwnBuffers)
            {
                void* pDataPointer = calloc(1, m_iPayloadSize);
                if (pDataPointer == NULL)
                {
                    char szMsg[256];
                    sprintf(szMsg, "Failed to allocate %d bytes for image buffer.", m_iPayloadSize);
                    QMessageBox::critical(m_pMainWindow, "Error", szMsg);
                    return false;
                }
                SynViewStatus = m_pStream->OpenBuffer(pDataPointer, m_iPayloadSize, NULL, 0, pBuffer);
            }
            else
            {
                SynViewStatus = m_pStream->OpenBuffer(NULL, 0, NULL, 0, pBuffer);
            }
            if (ErrorOccurred(SynViewStatus)) return false;
            m_pBufferVector.push_back(pBuffer);
            SynViewStatus = pBuffer->Queue();
            if (ErrorOccurred(SynViewStatus)) return false;
        }
        int PostponeBuffers = g_iNumberOfTiles;
        if ((PostponeBuffers+2) > g_iNumberOfBuffers) 
            PostponeBuffers = g_iNumberOfBuffers - 2;
        if (PostponeBuffers < 1) 
            PostponeBuffers = 1;

        // this needs to be done after any buffer allocation
        m_pStream->SetInt32(LvStream_LvPostponeQueueBuffers, 0);
        if (PostponeBuffers > 0) 
            m_pStream->SetInt32(LvStream_LvPostponeQueueBuffers, PostponeBuffers);
    }
    else
    {
        // Payload size not changed
    }
    return true;
}

//-----------------------------------------------------------------------------

void CCamera::StartAcquisition()
{
    if (m_pDevice == NULL) return;
    LvStatus SynViewStatus;
    m_pWidgetPaint->SetImageParam(m_pDevice);
    m_dwFrameCounter = 0;
    m_dwFrameCounterForFps = 0;
    if (!ReallocateBuffers()) return;
    SynViewStatus = m_pNewBufferEvent->StartThread();
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = m_pDevice->AcquisitionStart();
    if (ErrorOccurred(SynViewStatus)) return;
    m_bAcquisitionStarted = true;
}

//-----------------------------------------------------------------------------

void CCamera::StopAcquisition()
{
    if (!m_bAcquisitionStarted) return;
    LvStatus SynViewStatus;
    SynViewStatus = m_pDevice->AcquisitionStop();
    if (ErrorOccurred(SynViewStatus)) return;
    m_bAcquisitionStarted = false;
    SynViewStatus = m_pNewBufferEvent->StopThread();
    if (ErrorOccurred(SynViewStatus)) return;
    m_dwFrameCounterForFps = 0;
    SynViewStatus = m_pStream->FlushQueue(LvQueueOperation_AllToInput);
    if (ErrorOccurred(SynViewStatus)) return;
}

//-----------------------------------------------------------------------------

void CCamera::DisconnectCamera()
{
    if (m_pDevice == NULL) return;
    LvStatus SynViewStatus;
    StopAcquisition();
    if (m_pNewBufferEvent != NULL)
    {
        SynViewStatus = m_pStream->CloseEvent(m_pNewBufferEvent);
        if (ErrorOccurred(SynViewStatus)) return;
    }
    if (m_pRenderer != NULL)
    {
        SynViewStatus = m_pStream->CloseRenderer(m_pRenderer);
        if (ErrorOccurred(SynViewStatus)) return;
    }

    m_pStream->FlushQueue(LvQueueOperation_AllDiscard);
    for (int i=0; i<(int)m_pBufferVector.size(); i++)
    {
        LvBuffer* pBuffer = m_pBufferVector[i];
        if (g_bUseOwnBuffers)
        {
            void* pDataPointer = NULL;
            pBuffer->GetPtr (LvBuffer_Base, &pDataPointer);
            if (pDataPointer != NULL) free(pDataPointer);
        }
        SynViewStatus = m_pStream->CloseBuffer(pBuffer);
        if (ErrorOccurred(SynViewStatus)) return;
    }
    m_pBufferVector.clear();
    m_iPayloadSize = 0;
    if (m_pStream != NULL)
    {
        SynViewStatus = m_pDevice->CloseStream(m_pStream);
        if (ErrorOccurred(SynViewStatus)) return;
    }
    if (m_pDevice != NULL)
    {
        SynViewStatus = m_pInterface->CloseDevice(m_pDevice);
        if (ErrorOccurred(SynViewStatus)) return;
    }
    if (m_pInterface != NULL)
    {
        SynViewStatus = m_pSystem->CloseInterface(m_pInterface);
        if (ErrorOccurred(SynViewStatus)) return;
    }
    m_pScrollAreaImage->takeWidget();
    delete m_pWidgetPaint;
    m_pWidgetPaint = NULL;
    m_pLastBuffer = NULL;
}

//-----------------------------------------------------------------------------

bool CCamera::IsConnected()
{
    return m_pDevice != NULL;
}

//-----------------------------------------------------------------------------

bool CCamera::IsAcquiring()
{
    if (m_pDevice == NULL) return false;
    int32_t iIsAcquiring;
    m_pDevice->GetInt32(LvDevice_LvDeviceIsAcquiring, &iIsAcquiring);
    return iIsAcquiring != 0;
}

--- %%IF IncSimpleImgProcess=1 -----------
//-----------------------------------------------------------------------------

void CCamera::SetProcessing(bool bDoProcessing)
{
    m_bDoProcessing = bDoProcessing;
}

--- %%ENDIF ------------------------------
//-----------------------------------------------------------------------------

void CCamera::CallbackNewBuffer(LvBuffer* pBuffer)
{
    m_dwFrameCounterForFps++;
    m_dwFrameCounter++;
    CalculateFramesPerSecond();

    // Hint: In case you need to check if the image is complete, use this:
    // bool IsIncomplete;
    // pBuffer->GetBool(LvBuffer_IsIncomplete, &IsIncomplete);

    --- %%IF IncSimpleImgProcess=1 -----------
    // get the pointer to the image data
    void* pData = NULL;
    int32_t iImageOffset = 0;
    --- %%IF IncUniImgPreprocess=1 ------------------
    pBuffer->GetPtr (LvBuffer_UniBase, &pData);
    pBuffer->GetInt32 (LvBuffer_UniImageOffset, &iImageOffset);
    --- %%ELSE --------------------------------------
    pBuffer->GetPtr (LvBuffer_Base, &pData);
    pBuffer->GetInt32 (LvBuffer_ImageOffset, &iImageOffset);
    --- %%ENDIF -------------------------------------
    pData = (uint8_t*)pData + iImageOffset;
    if (m_bDoProcessing && pData != NULL)
    {
        // we will do some easy processing - invert the pixel values in an area
        int32_t iWidth;
        int32_t iHeight;
        int32_t iLinePitch;
        LvEnum iPixelFormat;    // LvPixelFormat enumeration value
        m_pDevice->GetInt32(LvDevice_Width, &iWidth);
        m_pDevice->GetInt32(LvDevice_Height, &iHeight);
        --- %%IF IncUniImgPreprocess=1 -----------
        m_pDevice->GetEnum(LvDevice_LvUniPixelFormat, &iPixelFormat);
        m_pDevice->GetInt32(LvDevice_LvUniLinePitch, &iLinePitch);
        int32_t iBytesPerPixel = ((iPixelFormat & LV_PIX_EFFECTIVE_PIXEL_SIZE_MASK) >> LV_PIX_EFFECTIVE_PIXEL_SIZE_SHIFT) / 8;
        --- %%ELSE -------------------------------
        m_pDevice->GetEnum(LvDevice_PixelFormat, &iPixelFormat);
        int iBitsPerPixel = (iPixelFormat & LV_PIX_EFFECTIVE_PIXEL_SIZE_MASK) >> LV_PIX_EFFECTIVE_PIXEL_SIZE_SHIFT;
        iLinePitch = ((iWidth * iBitsPerPixel)+7)/8;
        int32_t iBytesPerPixel = iBitsPerPixel / 8;
        --- %%ENDIF ------------------------------

        for (int32_t j=0; j<(iHeight/2); j++)
        {
            uint8_t* pPixel = ((uint8_t*)pData) + (iHeight/4 + j)*iLinePitch + (iWidth/4)*iBytesPerPixel;
            for (int32_t i=0; i<(iWidth/2); i++)
            {
                for (int32_t k=0; k<iBytesPerPixel; k++)
                {
                    *pPixel = ~*pPixel;
                    pPixel++;
                }
            }
        }
    }
    --- %%ELSE -------------------------------
    // no image processing demonstrated - switch it ON in the code generation Wizard if you need it
    --- %%ENDIF ------------------------------

    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    // before the chunk data can be read for this buffer, they must be parsed.
    pBuffer->ParseChunkData();
    int64_t ChunkValue;
    char szChunkLine[256];
    szChunkLine[0] = 0;
    char szValue[128];
    --- %%IF CHUNK_ENABLED OffsetX ---
    m_pDevice->GetInt64(LvDevice_ChunkOffsetX, &ChunkValue);
    sprintf(szValue, "X=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED OffsetY ---
    m_pDevice->GetInt64(LvDevice_ChunkOffsetY, &ChunkValue);
    sprintf(szValue, "Y=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Width ---
    m_pDevice->GetInt64(LvDevice_ChunkWidth, &ChunkValue);
    sprintf(szValue, "W=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Height ---
    m_pDevice->GetInt64(LvDevice_ChunkHeight, &ChunkValue);
    sprintf(szValue, "H=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED PixelFormat ---
    m_pDevice->GetInt64(LvDevice_ChunkPixelFormat, &ChunkValue);
    sprintf(szValue, "PF=0x%llx | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LinePitch ---
    m_pDevice->GetInt64(LvDevice_ChunkLinePitch, &ChunkValue);
    sprintf(szValue, "LPitch=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED FrameID ---
    m_pDevice->GetInt64(LvDevice_ChunkFrameID, &ChunkValue);
    sprintf(szValue, "FrameID=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Timestamp ---
    m_pDevice->GetInt64(LvDevice_ChunkTimestamp, &ChunkValue);
    sprintf(szValue, "Time=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED ExposureTime ---
    m_pDevice->GetInt64(LvDevice_ChunkExposureTime, &ChunkValue);
    sprintf(szValue, "Exp=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Gain ---
    // the LvIsAvailableEnumEntry() is time consuming, better if you move it outside this callback
    if (m_pDevice->IsAvailableEnumEntry(LvDevice_ChunkGainSelector, LvChunkGainSelector_AnalogAll) != 0)
    {
        m_pDevice->SetEnum (LvDevice_ChunkGainSelector, LvChunkGainSelector_AnalogAll);
        m_pDevice->GetInt64(LvDevice_ChunkGain, &ChunkValue);
        sprintf(szValue, "GainA=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (m_pDevice->IsAvailableEnumEntry(LvDevice_ChunkGainSelector, LvChunkGainSelector_DigitalAll) != 0)
    {
        m_pDevice->SetEnum (LvDevice_ChunkGainSelector, LvChunkGainSelector_DigitalAll);
        m_pDevice->GetInt64(LvDevice_ChunkGain, &ChunkValue);
        sprintf(szValue, "GainD=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LineStatusAll ---
    m_pDevice->GetInt64(LvDevice_ChunkLineStatusAll, &ChunkValue);
    sprintf(szValue, "Line=0x%llx | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LvExternalADCValue ---
    // the LvIsAvailableEnumEntry() is time consuming, better if you move it outside this callback
    if (m_pDevice->IsAvailableEnumEntry(LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC1) != 0)
    {
        m_pDevice->SetEnum (LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC1);
        m_pDevice->GetInt64(LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC1=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (m_pDevice->IsAvailableEnumEntry(LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC2) != 0)
    {
        m_pDevice->SetEnum (LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC2);
        m_pDevice->GetInt64(LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC2=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (m_pDevice->IsAvailableEnumEntry(LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC3) != 0)
    {
        m_pDevice->SetEnum (LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC3);
        m_pDevice->GetInt64(LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC3=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (m_pDevice->IsAvailableEnumEntry(LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC4) != 0)
    {
        m_pDevice->SetEnum (LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC4);
        m_pDevice->GetInt64(LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC4=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    --- %%ENDIF ------------------------------
    // m_szChunkLine is read from another thread, so make its filling safe
    memset(m_szChunkLine, 0, sizeof(m_szChunkLine));
    strcpy(m_szChunkLine, szChunkLine);
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------

    m_pWidgetPaint->DisplayImageFromAnotherThread(m_pStream, pBuffer);
    m_pLastBuffer = pBuffer;
    pBuffer->Queue();
}

//-----------------------------------------------------------------------------

void CCamera::SetRenderType(LvRenderType RenderType)
{
    m_RenderType = RenderType;
    m_pWidgetPaint->SetRenderType(RenderType);
}

//-----------------------------------------------------------------------------

LvRenderType CCamera::GetRenderType()
{
    return m_RenderType;
}

//-----------------------------------------------------------------------------

uint32_t CCamera::GetFrameCount()
{
    return m_dwFrameCounter;
}

//-----------------------------------------------------------------------------

double CCamera::CalculateFramesPerSecond()
{
    uint32_t dwCurrentTime = OsGetTickCount();
    if (dwCurrentTime > m_dwGrabStartTimeForFps && 
        (dwCurrentTime >= (m_dwGrabStartTimeForFps + 3000) ||
         m_dwFrameCounterForFps > 200))
    {
        if (m_dwFrameCounterForFps == 0)
            m_dFramesPerSec = 0;
        else
            m_dFramesPerSec = (((double)m_dwFrameCounterForFps + 0.5)*1000) / (double)(dwCurrentTime - m_dwGrabStartTimeForFps);
        m_dwFrameCounterForFps = 0;
        m_dwGrabStartTimeForFps = dwCurrentTime;
    }
    return m_dFramesPerSec;
}

--- %%IF IncUniImgPreprocess=1 -----------
//-----------------------------------------------------------------------------
// Determines optimal pixel format for the uni-process

void CCamera::SetOptimalUniPixelFormat()
{
    LvEnum PixelFormat;
    m_pDevice->GetEnum(LvDevice_PixelFormat, &PixelFormat);
    LvEnum UniPixelFormat = PixelFormat;
    switch (PixelFormat)
    {
        case LvPixelFormat_Mono8:
        case LvPixelFormat_Mono10:
        case LvPixelFormat_Mono12:
        case LvPixelFormat_Mono16:
            UniPixelFormat = LvPixelFormat_Mono8;
            break;

        case LvPixelFormat_BayerGR8:
        case LvPixelFormat_BayerRG8:
        case LvPixelFormat_BayerGB8:
        case LvPixelFormat_BayerBG8:
        case LvPixelFormat_BayerGR10:
        case LvPixelFormat_BayerRG10:
        case LvPixelFormat_BayerGB10:
        case LvPixelFormat_BayerBG10:
        case LvPixelFormat_BayerGR12:
        case LvPixelFormat_BayerRG12:
        case LvPixelFormat_BayerGB12:
        case LvPixelFormat_BayerBG12:
        case LvPixelFormat_RGB8Packed:
        case LvPixelFormat_RGBA8Packed:
            UniPixelFormat = LvPixelFormat_BGRA8Packed;
            break;
    }
    m_pDevice->SetEnum(LvDevice_LvUniPixelFormat, UniPixelFormat);
}

--- %%ENDIF ------------------------------
--- %%IF IncChunkData=1 ------------------
--- %%IF FEATURE ChunkModeActive ---
//-----------------------------------------------------------------------------
char* CCamera::GetChunkDataString()
{
    return m_szChunkLine;
}
--- %%ENDIF ------------------------------
--- %%ENDIF ------------------------------
//-----------------------------------------------------------------------------


