#ifndef __ICUBE_HID_H__
#define __ICUBE_HID_H__



#include <stdint.h>
#include <pthread.h>

#define MAX_CAM_NUM	16

typedef int CALLBACK_FCT(uint8_t buffer[], void* context);

//-----------------------------------------------------------------------------

class cHid
{
public:
	
	cHid(uint8_t nIndex);		
	~cHid();	
	
	uint8_t _open(uint16_t vid, uint16_t pid);
	void _close(void);

	void setCallback(CALLBACK_FCT* callback, void* context);

	uint8_t hidReport(uint8_t reportId, uint8_t commandId, uint8_t data[], uint8_t length);
	uint8_t hidFeature(uint8_t reportId, uint8_t data[], uint16_t length);
    uint8_t hidFeatureRd(uint8_t reportId, uint8_t *data, uint16_t length);
   
protected:
	
	uint8_t nCamIndex;	// CameraIndex

	int fd;
	
	pthread_t thread_hid;
	
	bool mTerminateFlag;
    void* mcontextHid;
    CALLBACK_FCT* mCallbackHid;
  
    int read_report(uint8_t* buf);

    void* ThreadRoutine(void *data);

}; 

extern cHid * mHid[MAX_CAM_NUM];   // ClassPointer 

extern uint8_t enumerate(uint16_t vid,uint16_t pid);
extern int gn_Vid,gn_Pid; 

#endif // ICUBE_HID_H
