
#include "chid.h"

#include <linux/types.h>
#include <linux/input.h>
#include <linux/hidraw.h>

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>

#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wpmf-conversions"

// global

int gn_Vid,gn_Pid;  

//-----------------------------------------------------------------------------

cHid * mHid[MAX_CAM_NUM];   // ClassPointer 

//-----------------------------------------------------------------------------
// 
cHid::cHid(uint8_t nIndex)
{
	 fd = -1;
	 mTerminateFlag = false;
     mcontextHid = NULL;

     nCamIndex = nIndex;
}
//-----------------------------------------------------------------------------
cHid::~cHid()
{
}
//-----------------------------------------------------------------------------
uint8_t cHid::_open(uint16_t vid, uint16_t pid) 
{
   uint8_t	dev_found=1,cnt=0;
   int status;
   struct hidraw_devinfo info;
   char hid_dev_name[32];

    for(int i=0;i< MAX_CAM_NUM;i++)
    {
		sprintf(hid_dev_name,"/dev/hidraw%d",i);
		
        // Open the Device with blocking reads.
        fd = open(hid_dev_name,O_RDWR);
        if (fd < 0) {
            return 1;
        }
		
        memset(&info, 0x0, sizeof(info));
			
        // Get Raw Info
        status = ioctl(fd, HIDIOCGRAWINFO, &info);
        if (status < 0) {
            perror("HIDIOCGRAWINFO");
            return 1;
        } else {
            #ifdef DBG_HID_INTERFACE
            printf("\tvendor: 0x%04hx\n", info.vendor);
            printf("\tproduct: 0x%04hx\n", info.product);
            #endif
        }
		
        if(( info.vendor == (int)vid) && ( info.product == (int)pid))
        {
			if(cnt == nCamIndex){
				dev_found = 0;
				break;
		    }
            cnt++;
        }
        close(fd);
    }
    
 
    if(dev_found == 0){
		typedef void * (*THREADFUNCPTR)(void *);
		cHid * pHid = this;
		pthread_create(&thread_hid, NULL, (THREADFUNCPTR) &cHid::ThreadRoutine, pHid);
	}
    
return dev_found;
}
//-----------------------------------------------------------------------------
void cHid::_close(void) 
{
   if(thread_hid != NULL)
	{
       mTerminateFlag = true;
       pthread_join(thread_hid, NULL);
    }
	
    close(fd);
}
//-----------------------------------------------------------------------------

uint8_t cHid::hidReport(uint8_t reportId, uint8_t commandId, uint8_t data[], uint8_t length)
{
    char buf[256];
    int status;
	
    memset(buf, 0x0, sizeof(buf));
	
    buf[0] = reportId;
    buf[1] = commandId;
		
    memcpy(&buf[2],data,length);
		 
    status = write(fd, buf, length+2);
    if (status < 0) {
        printf("Error: %d\n", errno);
        perror("write");
        return 1;
    }
    #ifdef DBG_HID_INTERFACE
    else {
        printf("write() wrote %d bytes\n", status);
    }
    #endif
return 0;
}
//-----------------------------------------------------------------------------

uint8_t cHid::hidFeature(uint8_t reportId, uint8_t data[], uint16_t length)
{
	int status;  
	char buf[1024];
	
	memset(buf, 0x0, sizeof(buf));
	
    buf[0] = reportId;
    	
    memcpy(&buf[1],data,length);
		 
	status = ioctl(fd, HIDIOCSFEATURE(1024), buf);
	if (status < 0){
		perror("HIDIOCSFEATURE");
		return 1;
	}
		
return 0;   
}
//-----------------------------------------------------------------------------

uint8_t cHid::hidFeatureRd(uint8_t reportId, uint8_t *data, uint16_t length)
{
	int status;  
	char buf[1024];
	
	memset(buf, 0x0, sizeof(buf));
	
    buf[0] = reportId;
    		 
	status = ioctl(fd, HIDIOCGFEATURE(1024), buf);
	if (status < 0){
		perror("HIDIOCSFEATURE");
		return 1;
	}
	
	memcpy(data,buf,length);
		
return 0;   
}
//------------------------------------------------------------------------
//
int cHid::read_report(uint8_t* buf)
{
    struct timeval timeout;
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;

    fd_set set;
    FD_ZERO(&set);              // clear the set
    FD_SET(fd, &set);           // add the file descriptor to the set
	
    int rv;
    rv = select(fd + 1, &set, NULL, NULL, &timeout);
    if(rv == -1){
        return 1;               // an error accured
    }
    else if(rv == 0){
        return 2;
    }
    else
    {
        int status = read( fd, buf, 64 ); // there was data to read
        if (status < 0) {
            return 3;
        }
        #ifdef DBG_HID_INTERFACE
        else {
            printf("read() read %d bytes:\n\t", status);
            for (int i = 0; i < status; i++)
                printf("%hhx ", buf[i]);
                puts("\n");
            }
        #endif
    }

return 0;
}
//------------------------------------------------------------------------
// 
void* cHid::ThreadRoutine(void *data)
{
    unsigned char rd_buf[256];

    for (;;)
    {
        int stat = read_report(rd_buf);
        if(stat == 0){
            mCallbackHid(rd_buf,mcontextHid);
        }

        #ifdef DBG_HID_INTERFACE
        else  printf("read_report stat %d\n",stat);
        #endif
        if (mTerminateFlag ==  true)    // thread termination
                break;
    }
		
return NULL;
}
//-----------------------------------------------------------------------------
void cHid::setCallback(CALLBACK_FCT* callback, void* context)
{
	mcontextHid = context;
	mCallbackHid = callback;
}

uint8_t enumerate(uint16_t vid,uint16_t pid)
{
	gn_Vid = vid;
	gn_Pid = pid;
	
	int status,cnt=0;
    struct hidraw_devinfo info;
   
   	char hid_dev_name[32];
	
	int fd = -1;
    for(int i=0;i< MAX_CAM_NUM;i++)
    {
		sprintf(hid_dev_name,"/dev/hidraw%d",i);
		
        // Open the Device with blocking reads.
        fd = open(hid_dev_name,O_RDWR);
        if (fd < 0) {
           goto ENUMERATE_END;
        }
		
        memset(&info, 0x0, sizeof(info));
			
        // Get Raw Info
        status = ioctl(fd, HIDIOCGRAWINFO, &info);
        if (status < 0) {
            perror("HIDIOCGRAWINFO");
            return 1;
        } else {
            #ifdef DBG_HID_INTERFACE
            printf("\tvendor: 0x%04hx\n", info.vendor);
            printf("\tproduct: 0x%04hx\n", info.product);
            #endif
        }
		
        if(( info.vendor == (int)gn_Vid) && ( info.product == (int)gn_Pid))
        {
           cnt++;
        }
        close(fd);
    } 
    
    ENUMERATE_END:
    
    #ifdef DBG_HID_INTERFACE
   	printf("NET_HID_Enumerate %x %x %x\n",gn_Vid,gn_Pid,cnt);
    #endif
    
	return cnt;
}
//------------------------------------------------------------------------
// [EOF]



