#ifndef __ICUBE_HID_API_H__
#define __ICUBE_HID_API_H__

#include <stdint.h>
 
#define CALLBACK 
 
 
typedef int CALLBACK_FCT(uint8_t buffer[], void* context);
 

extern uint8_t NET_HID_GetVersion(char* version, uint16_t length);
extern uint8_t NET_HID_Enumerate(uint16_t vid,uint16_t pid);
extern uint8_t NET_HID_Open(uint8_t cam_index);
extern uint8_t NET_HID_Close(uint8_t cam_index);
extern uint8_t NET_HID_Report(uint8_t cam_index,uint8_t reportId, uint8_t commandId,uint8_t data[],uint8_t length);
extern uint8_t NET_HID_SetCallbackHid(uint8_t cam_index,CALLBACK_FCT* callback, void* context);
extern uint8_t NET_HID_Feature(uint8_t cam_index,uint8_t reportId, uint8_t data[], uint16_t length) ;
extern uint8_t NET_HID_FeatureRd(uint8_t cam_index,uint8_t reportId, uint8_t *data, uint16_t length) ;

extern uint8_t NET_HID_Init(void); 
extern void NET_HID_DeInit(void);

#endif // __ICUBE_HID_API_H__
