#include "ICubeHID_Interface.h"
#include <stdio.h>
#include "chid.h"


//------------------------------------------------------------------------
// GLOBALS

//#define DBG_HID_INTERFACE


#define CAM_SUCCESS 0
#define CAM_ERROR   1


#define VERSION_BUILDNR		19
#define VERSION_YEAR		19
#define VERSION_WEEK		3
#define VERSION_DOW		    2


//------------------------------------------------------------------------
//
uint8_t NET_HID_GetVersion(char* version, uint16_t length)
{
    snprintf(version, (length-1), "%2d.%02d.%d.%d", VERSION_YEAR, VERSION_WEEK, VERSION_DOW, VERSION_BUILDNR);
	
return 0;	
}
//------------------------------------------------------------------------
//
uint8_t NET_HID_Enumerate(uint16_t vid,uint16_t pid)
{
	return enumerate(vid,pid);
}
//------------------------------------------------------------------------
//
uint8_t NET_HID_Open(uint8_t cam_index)
{
    uint8_t status = CAM_SUCCESS;

 	if(NULL == mHid[cam_index]){
		mHid[cam_index] = new cHid(cam_index);
		status = mHid[cam_index]->_open(gn_Vid, gn_Pid);
    }

	return status;
}
//------------------------------------------------------------------------
//
uint8_t NET_HID_Close(uint8_t cam_index)
{	
	uint8_t status = CAM_SUCCESS;

	if(NULL != mHid[cam_index]) {
		mHid[cam_index]->_close();
		delete mHid[cam_index];
		mHid[cam_index] = NULL;
	}

return status;
}
//------------------------------------------------------------------------
//
uint8_t NET_HID_Report(uint8_t cam_index,uint8_t reportId,uint8_t commandId,uint8_t data[],uint8_t length) 
{
    uint8_t status = CAM_ERROR;

	if(NULL != mHid[cam_index])
		status = mHid[cam_index]->hidReport(reportId, commandId, data, length);

	return status;
}
//------------------------------------------------------------------------
//
uint8_t NET_HID_SetCallbackHid(uint8_t cam_index,CALLBACK_FCT* callback, void* context)
{
	uint8_t status = CAM_SUCCESS;

    if(NULL != mHid[cam_index]) {
        mHid[cam_index]->setCallback(callback, context);
    }
    else {
        status = CAM_ERROR;
    }

    return status;
	
return 0;	
}
//------------------------------------------------------------------------
//
 uint8_t NET_HID_Feature(uint8_t cam_index,uint8_t reportId, uint8_t data[], uint16_t length) 
 {
    uint8_t status = CAM_ERROR;

	if(NULL != mHid[cam_index]) {
		status = mHid[cam_index]->hidFeature(reportId, data, length);
    }

	return status;	  
 }
 //------------------------------------------------------------------------
//
 uint8_t NET_HID_FeatureRd(uint8_t cam_index,uint8_t reportId, uint8_t *data, uint16_t length) 
 {
    uint8_t status = CAM_ERROR;

	if(NULL != mHid[cam_index]) {
		status = mHid[cam_index]->hidFeatureRd(reportId, data, length);
    }

	return status;	  
 }
//------------------------------------------------------------------------
//
uint8_t NET_HID_Init(void)
{
    // empty
return 0;    
}
//------------------------------------------------------------------------
//
void NET_HID_DeInit(void)
{
	// empty
}
//------------------------------------------------------------------------
// [EOF]

