#ifndef __ICUBE_HID_DEFINES_H__
#define __ICUBE_HID_DEFINES_H__


//---------------------------------------------------------------------------
// Global Defines

#define HID_PROT_VERSION_HIGH           3            // major version of hid protocol
#define HID_PROT_VERSION_LOW            05           // minor version of hid protocol


///////////////////////////////////////////////////
// Register Addresses

///////////////////////////////////////////////////
// Device Control

#define IC_UVC_GET_HID_PROT_VERSION        1          // hid protocol version

#define IC_UVC_INITIALZE_UPDATE            9
#define IC_UVC_DATA_UPDATE_WRITE_CONFIG    10
#define IC_UVC_DATA_UPDATE_FINISH          11

#define IC_UVC_SAVE_USER_MODE              52
#define IC_UVC_RESET_USER_MODE             53

#define IC_UVC_DATA_BLOCK_CREATE           75
#define IC_UVC_DATA_BLOCK_FINISH           76
#define IC_UVC_DATA_BLOCK_GET_INFO         77
#define IC_UVC_DATA_BLOCK_READ_CONFIG      78
#define IC_UVC_DATA_BLOCK_WRITE_CONFIG     79
#define IC_UVC_DATA_BLOCK_DELETE           80

///////////////////////////////////////////////////

#define IC_UVC_GET_VALUE                   92          // get the value of the selected setting control (see SETTING DEFINES)
#define IC_UVC_SET_VALUE                   93          // set the value of the selected setting control (see SETTING DEFINES)

///////////////////////////////////////////////////

#define IC_UVC_READ_EEP					   200

//////////////////////////////////////////
// SETTING DEFINES

// device control =======================================

#define UVC_CAM_REG_VENDOR_NAME				0x0500
#define UVC_CAM_REG_MODEL_NAME				0x0520
#define UVC_CAM_REG_FAMILY_NAME				0x0540
#define UVC_CAM_REG_MANU_INFO				0x0580
#define UVC_CAM_REG_DEVICE_VERS				0x05B0
#define UVC_CAM_REG_FIRMWARE_VERS			0x05D0
#define UVC_CAM_REG_SERIAL_NUMBER			0x05F0

#define UVC_CAM_REG_DEVICE_SCAN_TYPE_NUM	0x0600
#define UVC_CAM_REG_DEVICE_RESET			0x0604
#define UVC_CAM_REG_CLOCK_MODE_SEL			0x0608

#define UVC_CAM_REG_SENSOR_CLOCK			0x0000

#define UVC_CAM_REG_DEVICE_SCAN_TYPE_EN		0x060C

// image format control ===============================

#define UVC_CAM_REG_SENSOR_WIDTH			0x0610
#define UVC_CAM_REG_SENSOR_HEIGTH			0x0614

#define UVC_CAM_REG_BINNING_H				0x0618
#define UVC_CAM_REG_BINNING_V				0x061C

#define UVC_CAM_REG_SKIPPING_H				0x0620
#define UVC_CAM_REG_SKIPPING_V				0x0624

#define UVC_CAM_REG_ROI_SEL					0x0628
#define UVC_CAM_REG_ROI_EN					0x062C
#define UVC_CAM_REG_ROI_NUMBER				0x0630

#define UVC_CAM_REG_MAN_REG_EXP				0x0634

#define UVC_CAM_REG_BINNING_EN				0x063C
#define UVC_CAM_REG_SKIPPING_EN				0x0640

#define UVC_CAM_REG_PIXEL_FORMAT			0x0644
#define UVC_CAM_REG_PAYLOAD					0x0648

#define UVC_CAM_REG_WIDTH					0x0A04
#define UVC_CAM_REG_WIDTH_INC				0x1A04

#define UVC_CAM_REG_HEIGHT					0x0A08
#define UVC_CAM_REG_HEIGHT_INC				0x1A08

#define UVC_CAM_REG_OFFSET_X				0x0A0C
#define UVC_CAM_REG_OFFSET_X_INC			0x1A0C

#define UVC_CAM_REG_OFFSET_Y				0x0A10
#define UVC_CAM_REG_OFFSET_Y_INC			0x1A10

#define UVC_CAM_REG_FLIP_V					0x0A14
#define UVC_CAM_REG_FLIP_H					0x0A18

// aquisition control ==================================

#define UVC_CAM_REG_AQUIS_MODE				0x064C
#define UVC_CAM_REG_AQUIS_EN				0x0650
#define UVC_CAM_REG_EXPOSURE_MODE			0x0654

#define UVC_CAM_REG_AUTO_EXPOSURE			0x0A1C

#define UVC_CAM_REG_SENSOR_EXPOSURE			0x0A20

#define UVC_CAM_REG_TRIG_SELECTOR			0x0658
#define UVC_CAM_REG_TRIG_ENABLE				0x065C
#define UVC_CAM_REG_TRIG_SW_DO				0x0660
#define UVC_CAM_REG_TRIG_MODE				0x0664
#define UVC_CAM_REG_TRIG_ACTIVATION			0x0668

#define UVC_CAM_REG_TRIGGER_DELAY			0x0A24

#define UVC_CAM_REG_STROBE_SOURCE			0x066C

#define UVC_CAM_REG_STROBE_LENGHT			0x0A28
#define UVC_CAM_REG_STROBE_DELAY			0x0A2C

#define UVC_CAM_REG_SHUTTER_MODE			0x0670
#define UVC_CAM_REG_SHUTTER_ERS_EN			0x0674
#define UVC_CAM_REG_SHUTTER_GRR_EN			0x0678
#define UVC_CAM_REG_SHUTTER_GLOBAL_EN		0x067C

// digital io =========================================

#define UVC_CAM_REG_LINE_SEL				0x0680
#define UVC_CAM_REG_LINE_INVERTER			0x0684
#define UVC_CAM_REG_LINE_SOURCE				0x0688
#define UVC_CAM_REG_LINE_STATUS				0x068C
#define UVC_CAM_REG_LINE_STATUS_ALL			0x0690
#define UVC_CAM_REG_LINE_USER_OUTPUT_SEL	0x0694
#define UVC_CAM_REG_LINE_USER_OUTPUT_VAL	0x0698
#define UVC_CAM_REG_LINE_USER_OUTP_VAL_ALL	0x069C
#define UVC_CAM_REG_MODE_SEL				0x06A0

// analog control =========================================

#define UVC_CAM_REG_BALANCE_RATIO_SEL		0x06A4
#define UVC_CAM_REG_BALANCE_RATIO			0x06A8

#define UVC_CAM_REG_WHITE_BALANCE			0x0A30

#define UVC_CAM_REG_BLACKLEVEL_MODE			0x06AC

#define UVC_CAM_REG_AUTO_BLACKLEVEL			0x0A34
#define UVC_CAM_REG_SENSOR_BLK_LEV			0x0A38

#define UVC_CAM_REG_BL_ENABLE				0x06B0
#define UVC_CAM_REG_GAIN_MODE				0x06B4

#define UVC_CAM_REG_SENSOR_GAIN				0x0A3C
#define UVC_CAM_REG_GAMMA					0x0A40

// lut control =========================================

#define UVC_CAM_REG_LUT_VALUE				0x06B8
#define UVC_CAM_REG_LUT_EN					0x06BC
#define UVC_CAM_REG_LUT_SEL					0x06C0
#define UVC_CAM_REG_LUT_MAP_SAVE_LOAD		0x06C4
#define UVC_CAM_REG_LUT_INDEX				0x06C8

// user set control ====================================

#define UVC_CAM_REG_USER_SET_LOAD			0x06CC
#define UVC_CAM_REG_USER_SET_SAVE			0x06D0
#define UVC_CAM_REG_USER_SET_DEFAULT		0x06D4
#define UVC_CAM_REG_USER_SET_BUSY			0x06D8
#define UVC_CAM_REG_USER_SET_SEL			0x06DC

// color transformation control ========================

#define UVC_CAM_REG_MATRIX_EN				0x06E0
#define UVC_CAM_REG_MATRIX_SEL				0x06E4
#define UVC_CAM_REG_MATRIX_COEFF_SEL		0x06E8
#define UVC_CAM_REG_MATRIX_COEFF_REG		0x06EC

// custom control =========================================

#define UVC_CAM_REG_UVC_INTERFACE			0x06F0

#define UVC_CAM_REG_BRIGHTNESS				0x0A44
#define UVC_CAM_REG_CONTRAST				0x0A48
#define UVC_CAM_REG_SATURATION				0x0A4C
#define UVC_CAM_REG_HUE						0x0A50

#define UVC_CAM_REG_EDGE_SENS				0x06F4

#define UVC_CAM_REG_EXP_TARGET				0x0A54
#define UVC_CAM_REG_EXP_MIN_TIME			0x0A58
#define UVC_CAM_REG_EXP_MAX_TIME			0x0A5C

#define UVC_CAM_REG_AE_FIELD_SEL			0x0A60		// ae field
#define UVC_CAM_REG_GAMMA_ENABLE			0x0A64

#define UVC_CAM_REG_WB_SPEED				0x0A78
#define UVC_CAM_REG_UVC_EV  				0x0A7C
#define UVC_CAM_REG_UVC_LATE_TRIGGER		0x0A80

// ffc

#define UVC_CAM_REG_FFC_ID					0x0800
#define UVC_CAM_REG_FFC_PICX				0x0804
#define UVC_CAM_REG_FFC_PICY				0x0808
#define UVC_CAM_REG_FFC_CMD					0x080c
#define UVC_CAM_REG_FFC_IN					0x0810

// dpc

#define UVC_CAM_REG_DPC_EN					0x0900
#define UVC_CAM_REG_DPC_DETECT				0x0904
#define UVC_CAM_REG_DPC_THRES				0x0908
#define UVC_CAM_REG_DPC_IN					0x090C
#define UVC_CAM_REG_DPC_MAP_VAL				0x0910
#define UVC_CAM_REG_DPC_IND_VAL				0x0914


#define UVC_CAM_REG_FFC_MAPEntry_Start		0x5000
#define UVC_CAM_REG_FFC_MAPEntry_End		0x8000

// misc.

#define UVC_CAM_REG_BINNING_MAX				0x3618
#define UVC_CAM_REG_SKIPPING_MAX			0x3620


#define UVC_CAM_REG_COLOR					0x0A68
#define UVC_CAM_REG_DEFECT_COR				0x0A6C
#define UVC_CAM_REG_AE_FIELD_VAL			0x0A70		// ae field
#define UVC_CAM_REG_UVC_LOCKED				0x0A74		// UVC only implemented

#define UVC_CAM_REG_BL_AUTO_ENABLE			0x06F8
#define UVC_CAM_REG_STROBE_EXP_EN			0x06FC


#define UVC_CAM_REG_C10BIT_ENABLED			0x0700
#define UVC_CAM_REG_B10BIT_ENABLED			0x0704
#define UVC_CAM_REG_LINE_PITCH				0x0708
#define UVC_CAM_REG_BINNING_LOCKED			0x070C
#define UVC_CAM_REG_SKIPPING_LOCKED			0x0710
#define UVC_CAM_REG_TEST_PENDING			0x0714
#define UVC_CAM_REG_C12BIT_ENABLED			0x0718
#define UVC_CAM_REG_B12BIT_ENABLED			0x071C
#define UVC_CAM_REG_YUV_BIT_ENABLED			0x0720
#define UVC_CAM_REG_DEFECT_COR_ENABLED		0x0724
#define UVC_CAM_REG_DEVICE_RESET_DGB		0x0728		// used with debug tool

#define UVC_CAM_REG_SAVE_FACTORY_MATRIX		0x072C		// needs xml version >= 1.03

#define UVC_CAM_REG_TS_CTRL_LATCH			0x0730
#define UVC_CAM_REG_EVENT_SELECTOR			0x0734
#define UVC_CAM_REG_EVENT_IMPLEMENTED		0x0738
#define UVC_CAM_REG_TIMESTAMP_LOW			0x073C

#define UVC_CAM_REG_TIMESTAMP_HIGH			0x0740

#define UVC_CAM_REG_AQUIS_FRATE_CTRL		0x0744
#define UVC_CAM_REG_AQUIS_FRATE_CTRL_EN		0x0748

////////////////////////////////////////////////////////


//////////////////////////////////////////
// ERROR DEFINES

#define IC_UVC_STATUS_SUCCESS                0

#define IC_UVC_STATUS_UNKNOWN_ERROR          1
#define IC_UVC_STATUS_BAD_ARGUMENT           2
#define IC_UVC_STATUS_INVALID_CMD_ID         3
#define IC_UVC_STATUS_NOT_IMPLEMENTED        4
#define IC_UVC_STATUS_NOT_AVAILABLE          5

#define IC_UVC_STATUS_INVALID_DATA_BLOCK     6
#define IC_UVC_STATUS_INVALID_CHUNK_ID       7
#define IC_UVC_STATUS_DATA_BLOCK_TOO_LARGE   8
#define IC_UVC_STATUS_MISSSING_DATA_CHUNKS   9
#define IC_UVC_STATUS_SENSOR_DISABLED        10

#define IC_UVC_STATUS_USB_RD_ERR             11
#define IC_UVC_STATUS_USB_WR_ERR             12
#define IC_UVC_STATUS_FLASH_RD_ERR           13
#define IC_UVC_STATUS_FLASH_WR_ERR           14
#define IC_UVC_STATUS_OUT_OF_RANGE           15

#define IC_UVC_STATUS_HW_ERR                 16
#define IC_UVC_STATUS_NOT_IF_STREAMING_ERROR 17
#define IC_UVC_STATUS_HW_ERR_FPGA            18


//////////////////////////////////////////
// USER MODE DEFINES

#define HID_USER_MODE_1                      0
#define HID_USER_MODE_2                      1
#define HID_USER_MODE_3                      2

//////////////////////////////////////////
// EVENT DEFINES

#define EVENT_ID_AQU_START		          0x01
#define EVENT_ID_AQU_END                  0x02
#define EVENT_ID_FRAME_TRG                0x20
#define EVENT_ID_LINE2_RISING_EDGE	      0x03	// gpio 0
#define EVENT_ID_LINE3_RISING_EDGE	      0x04  // gpio 1
#define EVENT_ID_LINE4_RISING_EDGE	      0x05  // gpio 2
#define EVENT_ID_LINE2_FALLING_EDGE	      0x06
#define EVENT_ID_LINE3_FALLING_EDGE	      0x07
#define EVENT_ID_LINE4_FALLING_EDGE	      0x08



//////////////////////////////////////////
// SHUTTER DEFINES

#define HID_SHUTTER_ROLLING	                   0
#define HID_SHUTTER_GLOBAL_RESET	           1
#define HID_SHUTTER_GLOBAL			 		   2

//////////////////////////////////////////
// TRIGGER_MODE DEFINES

#define HID_TRIGGER_SOURCE_OFF                 0         // Disable the selected trigger.
#define HID_TRIGGER_SOURCE_ON                  1         // Enable the selected trigger.

//////////////////////////////////////////
// TRIGGER_SOURCE DEFINES

#define HID_TRIGGER_SOURCE_SOFTWARE            0         // Select software trigger, generated by the TriggerSoftware command.
#define HID_TRIGGER_SOURCE_HARDWARE            1         // Select hardware trigger (line 1).

//////////////////////////////////////////
// STRING DEFINES

#define IC_UVC_NAME_LENGTH		         		12	   // length of the name strings

#endif // __ICUBE_HID_DEFINES_H__
