#ifndef __ICUBE_HID_H__
#define __ICUBE_HID_H__

#include <stdint.h>


#ifdef __linux__
#include <pthread.h>
#include <sys/time.h>
#include "ICubeHID_Interface.h"
#endif


#define HID_ERROR_TIMEOUT                   -1
#define HID_ERROR_PROTOCOL_WRONG_ID         -2


class ICube_HID
{
public:
    ICube_HID();
    ~ICube_HID();

    int Init(uint16_t vid,uint16_t pid,uint8_t *n_num_of_cams);
    int Open(uint8_t cam_index);
    int Close(uint8_t cam_index);
    int GetVersion(uint8_t cam_index,unsigned char nID,char* version, unsigned char length);

    int SetGlobal(uint8_t cam_index,uint16_t nID,uint32_t nValue);
    int GetGlobal(uint8_t cam_index,uint16_t nID,uint32_t* nValue);

    int SetInt32(uint8_t cam_index,uint16_t nID,uint32_t nValue);
    int GetInt32(uint8_t cam_index,uint16_t nID,uint32_t* nValue);

    int SetFloat(uint8_t cam_index,uint16_t nID,float fValue);
    int GetFloat(uint8_t cam_index,uint16_t nID,float* fValue);

    int SetFunc(uint8_t cam_index,uint16_t nFuncID,unsigned char* ndata,int len);
    int GetFunc(uint8_t cam_index,uint16_t nFuncID,unsigned char* ndata,int len);


    unsigned char n_event[12];

private:

    static int32_t CALLBACK ReceiveCallbackHid(uint8_t buffer[], void *context);

    int n_mode;

    int n_data_offset;
    int n_id;
    int n_cmd_error;

    unsigned char rcv_buf[64];

    #ifdef __linux__
    pthread_cond_t condition;
    pthread_mutex_t signalMutex;
    #endif
    #ifdef __WIN32__
    HANDLE m_hndEvent;
    #endif

    
};


#endif // __ICUBE_HID_H__
