Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Windows.Forms
Imports System.Runtime.InteropServices ' for Marshal
Imports NewElectronicTechnology.SynView

Public Class CCamera

    Private Const NumberOfBuffers As Int32 = %%Buffers%%
    Private m_pSystem As LvSystem
    Private m_pInterface As LvInterface
    Private m_pDevice As LvDevice
    Private m_pStream As LvStream
    Private m_pRenderer As LvRenderer
    Private m_Buffers(NumberOfBuffers) As LvBuffer
    Private m_hDisplayWnd As IntPtr
    Private WithEvents m_pEvent As LvEvent
    --- %%IF IncSimpleImgProcess=1 ------------------
    Private m_bDoProcessing As Boolean
    --- %%ENDIF -------------------------------------

    Public Sub New()
        m_pSystem = Nothing
        m_pInterface = Nothing
        m_pDevice = Nothing
        m_pStream = Nothing
        m_pRenderer = Nothing
        m_pEvent = Nothing
        For Each Buffer As LvBuffer In m_Buffers
            Buffer = Nothing
        Next
        m_hDisplayWnd = 0
        --- %%IF IncSimpleImgProcess=1 ------------------
        m_bDoProcessing = False
        --- %%ENDIF -------------------------------------
    End Sub

    Public Sub OpenCamera(ByVal hDisplayWnd As IntPtr, ByVal pSystem As LvSystem)
        Try
            If m_pDevice IsNot Nothing Then CloseCamera()
            m_pSystem = pSystem
            m_hDisplayWnd = hDisplayWnd

            Dim pInterface As LvInterface = Nothing
            Dim pDevice As LvDevice = Nothing
            pSystem.UpdateInterfaceList()

            --- %%IF OpenInterface=ByInterfaceId -------
            pSystem.OpenInterface("%%INTERFACE_ID%%", pInterface)
            --- %%ENDIF --------------------------------
            --- %%IF OpenInterface=ByInterfaceTlType ---
            Dim InterfaceId As String = ""
            pSystem.FindInterface(LvFindBy.TLType, "%%INTERFACE_TLTYPE%%", InterfaceId)
            pSystem.OpenInterface(InterfaceId, pInterface)
            --- %%ENDIF --------------------------------

            pInterface.UpdateDeviceList()
            --- %%IF OpenDevice=ByDeviceId -------------
            pInterface.OpenDevice("%%DEVICE_ID%%", pDevice, LvDeviceAccess.Control)
            --- %%ENDIF --------------------------------
            --- %%IF OpenDevice=ByDeviceModelName ------
            Dim DeviceId As String = ""
            pInterface.FindDevice(LvFindBy.ModelName, "%%DEVICE_MODELNAME%%", DeviceId)
            pInterface.OpenDevice(DeviceId, pDevice, LvDeviceAccess.Control)
            --- %%ENDIF --------------------------------
            --- %%IF OpenDevice=ByDeviceIpAddress ------
            Dim DeviceId As String = ""
            pInterface.FindDevice(LvFindBy.GevIPAddress, "%%DEVICE_IPADDRESS%%", DeviceId)
            pInterface.OpenDevice(DeviceId, pDevice, LvDeviceAccess.Control)
            --- %%ENDIF --------------------------------
            --- %%IF OpenDevice=ByDeviceUserId ---------
            Dim DeviceId As String = ""
            pInterface.FindDevice(LvFindBy.UserID, "%%DEVICE_USERID%%", DeviceId)
            pInterface.OpenDevice(DeviceId, pDevice, LvDeviceAccess.Control)
            --- %%ENDIF --------------------------------
            --- %%IF Sys.AutoLoadedCfg=1 -------------
            ' Note: When the code was generated, in SynView Explorer was switched ON the option
            ' to autoload the camera settings after opening the camera. For this reason the following
            ' line loads the camera settings from the file to assure the same starting status.
            --- %%ENDIF ------------------------------
            --- %%IF Sys.SnippetFile=1 -----------------
            pDevice.LoadSettings("", "%%Sys.CameraCfgFile%%", LvSaveFlag.All)
            --- %%ENDIF --------------------------------

            --- %%IF Snippet=All ---------------------
            '  IMPORTANT: go carefully through all the feature settings below and
            '  leave there only those, which really need to be set.

            --- %%ENDIF ------------------------------
            --- %%IF Snippet=Streamable --------------
            '  IMPORTANT: go carefully through all the feature settings below and
            '  leave there only those, which really need to be set.

            --- %%ENDIF ------------------------------
            %%CameraRemoteFeaturesCode%%

            m_pInterface = pInterface
            m_pDevice = pDevice

            --- %%IF IncUniImgPreprocess=1 -------------
            m_pDevice.SetEnum(LvDeviceFtr.LvUniProcessMode, LvUniProcessMode.Auto)
            SetOptimalUniPixelFormat()

            --- %%ENDIF --------------------------------
            m_pDevice.OpenStream("", m_pStream)
            m_pStream.OpenEvent(LvEventType.NewBuffer, m_pEvent)
            Dim i As Integer = 0
            Do While i < NumberOfBuffers
                m_pStream.OpenBuffer(0, 0, 0, 0, m_Buffers(i))
                m_pStream.SetInt32(LvStreamFtr.LvPostponeQueueBuffers, 3)
                i += 1
            Loop
            m_pStream.OpenRenderer(m_pRenderer)
            m_pRenderer.SetWindow(m_hDisplayWnd)
            m_pEvent.SetCallbackNewBuffer(True, 0)
            m_pEvent.StartThread()

        Catch ex As LvException
            MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Public Sub StartAcquisition()
        Try
            m_pStream.FlushQueue(LvQueueOperation.AllToInput)
            If m_pDevice Is Nothing Then Exit Sub
            m_pDevice.AcquisitionStart()
        Catch ex As LvException
            MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Public Sub StopAcquisition()
        Try
            If m_pStream Is Nothing Then Exit Sub
            m_pDevice.AcquisitionStop()
        Catch ex As LvException
            MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub


    Public Sub CloseCamera()
        Try
            If m_pDevice Is Nothing Then Exit Sub
            If IsAcquiring() Then StopAcquisition()
            m_pEvent.StopThread()
            m_pEvent.SetCallbackNewBuffer(False, 0)
            m_pStream.CloseEvent(m_pEvent)
            m_pStream.CloseRenderer(m_pRenderer)
            Dim i As Integer = 0
            m_pStream.FlushQueue(LvQueueOperation.AllDiscard)
            Do While i < NumberOfBuffers
                If m_Buffers(i) IsNot Nothing Then
                    m_pStream.CloseBuffer(m_Buffers(i))
                End If
                i += 1
            Loop
            m_pDevice.CloseStream(m_pStream)
            m_pInterface.CloseDevice(m_pDevice)
            m_pSystem.CloseInterface(m_pInterface)
        Catch ex As LvException
            MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Public Function IsOpen() As Boolean
        If m_pDevice IsNot Nothing Then
            Return True
        End If
        Return False
    End Function

    Public Function IsAcquiring() As Boolean
        If m_pDevice Is Nothing Then
            Return False
        End If
        Dim bIsAcquiring As Boolean = False
        Try
            m_pDevice.GetBool(LvDeviceFtr.LvDeviceIsAcquiring, bIsAcquiring)
        Catch ex As LvException
            'no message
            bIsAcquiring = False
        End Try
        Return bIsAcquiring
    End Function

    --- %%IF IncSimpleImgProcess=1 ------------------
    Public Sub SetProcessing(ByVal bDoProcessing As Boolean)
        m_bDoProcessing = bDoProcessing
    End Sub

    --- %%ENDIF -------------------------------------
    --- %%IF IncUniImgPreprocess=1 ------------------
    Private Sub SetOptimalUniPixelFormat()
        Dim PixelFormat As UInt32 = LvPixelFormat.Mono8
        m_pDevice.GetEnum(LvDeviceFtr.PixelFormat, PixelFormat)
        Dim UniPixelFormat As UInt32 = PixelFormat
        Select Case PixelFormat
            Case LvPixelFormat.Mono8
                UniPixelFormat = LvPixelFormat.Mono8
            Case LvPixelFormat.Mono10
                UniPixelFormat = LvPixelFormat.Mono8
            Case LvPixelFormat.Mono12
                UniPixelFormat = LvPixelFormat.Mono8
            Case LvPixelFormat.Mono16
                UniPixelFormat = LvPixelFormat.Mono8
            Case LvPixelFormat.BayerGR8
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerRG8
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerGB8
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerBG8
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerGR10
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerRG10
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerGB10
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerBG10
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerGR12
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerRG12
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerGB12
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.BayerBG12
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.RGB8Packed
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case LvPixelFormat.RGBA8Packed
                UniPixelFormat = LvPixelFormat.BGRA8Packed
            Case Else
                UniPixelFormat = LvPixelFormat.Mono8
        End Select
        m_pDevice.SetEnum(LvDeviceFtr.LvUniPixelFormat, UniPixelFormat)
    End Sub

    --- %%ENDIF -------------------------------------
    Public Sub Repaint()
        Try
            If m_pRenderer IsNot Nothing Then
                m_pRenderer.Repaint()
            End If
        Catch ex As LvException
            'no message
        End Try
    End Sub

    Public Sub NewBufferEventHandler(ByVal sender As System.Object, ByVal e As LvNewBufferEventArgs) Handles m_pEvent.OnEventNewBuffer
        Try
            If e.Buffer Is Nothing Then Exit Sub

            --- %%IF IncSimpleImgProcess=1 ------------------
            Dim pData As IntPtr
            Dim iImageOffset as Int64
            --- %%IF IncUniImgPreprocess=1 ------------------
            e.Buffer.GetPtr(LvBufferFtr.UniBase, pData)
            e.Buffer.GetInt(LvBufferFtr.UniImageOffset, iImageOffset)
            --- %%ELSE --------------------------------------
            e.Buffer.GetPtr(LvBufferFtr.Base, pData)
            e.Buffer.GetInt(LvBufferFtr.ImageOffset, iImageOffset)
            --- %%ENDIF -------------------------------------
            pData = pData.ToInt64() + iImageOffset
            If m_bDoProcessing And pData <> 0 Then
                ' we will do some easy processing - invert the pixel values in an area
                Dim iWidth As Int32 = 0
                Dim iHeight As Int32 = 0
                Dim iLinePitch As Int32 = 0
                Dim iPixelFormat As UInt32 = 0    ' LvPixelFormat enumeration value
                m_pDevice.GetInt32(LvDeviceFtr.Width, iWidth)
                m_pDevice.GetInt32(LvDeviceFtr.Height, iHeight)
                --- %%IF IncUniImgPreprocess=1 ------------------
                m_pDevice.GetEnum(LvDeviceFtr.LvUniPixelFormat, iPixelFormat)
                m_pDevice.GetInt32(LvDeviceFtr.LvUniLinePitch, iLinePitch)
                Dim iBytesPerPixel As Int32 = ((iPixelFormat And &HFF0000) >> 16) \ 8
                --- %%ELSE --------------------------------------
                m_pDevice.GetEnum(LvDeviceFtr.PixelFormat, iPixelFormat)
                Dim iBitsPerPixel As Int32 = (iPixelFormat And &HFF0000) >> 16
                iLinePitch = ((iWidth * iBitsPerPixel)+7) \ 8
                Dim iBytesPerPixel As Int32 = iBitsPerPixel \ 8
                --- %%ENDIF -------------------------------------

                Dim j As Integer = 0
                Do While j < (iHeight \ 2)
                    Dim BaseOffset As Int32
                    BaseOffset = (iHeight \ 4 + j) * iLinePitch + (iWidth \ 4) * iBytesPerPixel
                    Dim i As Integer
                    i = 0
                    Do While i < (iBytesPerPixel * iWidth / 2)
                        Dim k As Integer
                        k = 0
                        Do While k < iBytesPerPixel
                            k += 1
                            ' In VB we can use the Marshal class to access data pointed
                            ' by unmanaged pointers. However, this way of accessing unmanaged
                            ' data is ineffective (may slow down the acquisition).
                            Dim Pixel As Byte = Marshal.ReadByte(pData, BaseOffset + i + k)
                            Pixel = Not Pixel
                            Marshal.WriteByte(pData, BaseOffset + i + k, Pixel)
                        Loop
                        i += iBytesPerPixel
                    Loop
                    j += 1
                Loop
            End If
            --- %%ELSE --------------------------------------
            ' no image processing demonstrated - switch it ON in the code generation Wizard if you need it
            --- %%ENDIF -------------------------------------

            m_pRenderer.DisplayImage(e.Buffer)
            e.Buffer.Queue()
        Catch ex As LvException
            ' no message
        End Try
    End Sub

End Class

