#ifndef _PAINT_H
#define _PAINT_H

#include <QWidget>
#include <QPixmap>
#include <QPainter>
#include <QPaintEvent>
#include <QPaintEngine>

#include <sv.synview.h>

class CWidgetPaint : public QWidget
{
    Q_OBJECT
public:
    CWidgetPaint(QWidget *parent = 0);
    ~CWidgetPaint();
    virtual QPaintEngine* paintEngine() const;
    void SetImageParam(LvHDevice hCamera);
    void DisplayImageFromAnotherThread(LvHStream hStream, LvHBuffer hBuffer);
    virtual QSize sizeHint() const;
    void SetRenderType(LvRenderType RenderType);

    void SetRenderer(LvHRenderer hRenderer);
    #ifdef USE_IDLE_TIMER
        void Idle();
    #endif

protected:
    virtual void paintEvent (QPaintEvent * pEvent);
private:
    LvHDevice     m_hDevice;
    LvHStream     m_hStream;
    LvHBuffer     m_hBuffer;
    LvHBuffer     m_hLastBuffer;
    LvRenderType  m_RenderType;
    WId           m_WinId;
    #ifndef _WIN32
        void*     m_pDisplay;
    #endif
    int32_t       m_iSrcWidth;
    int32_t       m_iSrcHeight;
    int32_t       m_iPaintWidth;   // paint rectangle - if changes, we erase background
    int32_t       m_iPaintHeight;
    bool          m_bBackgroundRepaintNeeded;
    int32_t       m_iLastParentWidth;
    int32_t       m_iLastParentHeight;
    LvHRenderer   m_hRenderer;

    void OsDisplayImage();

};

#endif