#ifndef _MAINWINDOW_H
#define _MAINWINDOW_H

#include <QMainWindow>

QT_BEGIN_NAMESPACE
class QAction;
class QActionGroup;
class QDialogButtonBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QMenu;
class QMenuBar;
class QToolBar;
class QPushButton;
class QTextEdit;
class QTreeWidget;
class QScrollArea;
class QSplitter;
QT_END_NAMESPACE

#include <string>
#include <vector>
#include <sv.synview.h>
#include "camera.h"

typedef std::vector<std::string> CStringVector;
typedef std::vector<QAction*> CActionVector;
typedef std::vector<int> CIndexVector;

class CMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    CMainWindow(QApplication* pApplication);

protected:
    virtual void closeEvent (QCloseEvent * event);

public slots:
    void OnTimer();
    void ActionDisplayClipped();
    void ActionDisplayScaled();
    void ActionDisplayTiled();
    void ActionConnectCamera();
    void ActionAcquisitionStart();
    void ActionAcquisitionStop();
    void ActionDisconnectCamera();
    --- %%IF IncSimpleImgProcess=1 -----------
    void ActionSimpleImageProcessing(bool bChecked);
    --- %%ENDIF ------------------------------

private:
    void CreateMenuAndToolBar();
    void CreateCameraClass();
    void DeleteCameraClass();
    void UpdateControls();
    void SetSizes();

    QMenuBar*     m_pMenuBar;
    QToolBar*     m_pToolBar; 
    QScrollArea*  m_pScrollAreaImage;
    QLabel*       m_pLabelChunkData;
    QSplitter*    m_pPanelImgSplitter;
    QWidget*      m_pPanel;

    QMenu*        m_pMenuFile;
    QMenu*        m_pMenuCamera;
    QMenu*        m_pMenuAcquisition;
    #ifdef _WIN32
        QMenu*    m_pMenuDisplay;
    #endif

    QActionGroup* m_pActionGroupDisplayMode;

    QAction*      m_pActionAcquisitionStart;
    QAction*      m_pActionAcquisitionStop;
    QAction*      m_pActionConnectCamera;
    QAction*      m_pActionDisconnectCamera;
    QAction*      m_pActionDisplayClipped;
    QAction*      m_pActionDisplayScaled;
    QAction*      m_pActionDisplayTiled;
    --- %%IF IncSimpleImgProcess=1 -----------
    QAction*      m_pActionSimpleImageProcessing;
    --- %%ENDIF ------------------------------
    QAction*      m_pActionExit;

    QTimer*       m_pTimer;
    QApplication* m_pApplication;
    CCamera*      m_pCamera;
    uint32_t      m_dwLastFrameCount;
};

#endif
