#define _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_DEPRECATE

#include <QMessageBox>

#include "camera.h"
#include "mainwindow.h"
#include "osdep.h"

bool g_bUseOwnBuffers   = false;
int  g_iNumberOfBuffers = %%Buffers%%;
int  g_iNumberOfTiles   = 6;

//-----------------------------------------------------------------------------
// The callback function

void LV_STDC CallbackNewBufferFunction(LvHBuffer hBuffer,
                                        void* pUserPointer, 
                                        void* pUserParam)
{
    CCamera* pCamera = (CCamera*) pUserParam;
    pCamera->CallbackNewBuffer(hBuffer, pUserPointer);
}

//-----------------------------------------------------------------------------

CCamera::CCamera(CMainWindow* MainWindow)
{
    m_pMainWindow           = MainWindow;
    m_hSystem               = 0;
    m_hInterface            = 0;
    m_hDevice               = 0;
    m_hStream               = 0;
    m_hRenderer             = 0;
    m_hNewBufferEvent       = 0;
    m_RenderType            = LvRenderType_FullSize;
    m_bAcquisitionStarted   = false;
    m_dwGrabStartTimeForFps = OsGetTickCount();
    m_dwFrameCounterForFps  = 0;
    m_dwFrameCounter        = 0;
    m_dFramesPerSec         = 0;
    m_iPayloadSize          = 0;
    m_hLastBuffer           = 0;
    --- %%IF IncSimpleImgProcess=1 -----------
    m_bDoProcessing         = false;
    --- %%ENDIF ------------------------------
    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    memset(m_szChunkLine, 0, sizeof(m_szChunkLine));
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------
    LvStatus SynViewStatus;
    SynViewStatus = LvSystemOpen("", &m_hSystem);
    if (ErrorOccurred(SynViewStatus)) return;
}

//-----------------------------------------------------------------------------

CCamera::~CCamera()
{
    if (m_hDevice) DisconnectCamera();
    LvSystemClose(&m_hSystem);
}

//-----------------------------------------------------------------------------
// Error check with a message box displayed, when it is an error

bool CCamera::ErrorOccurred(LvStatus ErrorStatus)
{
    if (ErrorStatus == LVSTATUS_OK) return false;
    char szMessage[512];
    LvGetErrorMessage(ErrorStatus, szMessage, sizeof(szMessage));
    QMessageBox::critical(m_pMainWindow, "Error", szMessage);
    return true;
}

//-----------------------------------------------------------------------------

void CCamera::ConnectCamera(QScrollArea* pScrollAreaImage)
{
    if (m_hDevice != 0) DisconnectCamera();
    m_pScrollAreaImage = pScrollAreaImage; 
    %%REM The SynViewStatus is used instead of ErrorStatus, because the SynViewGen inserts ErrorStatus in CameraRemoteFeaturesCode
    LvStatus SynViewStatus;
    LvHInterface hInterface;
    LvHDevice hDevice;
    LvSystemUpdateInterfaceList(m_hSystem);
    --- %%IF OpenInterface=ByInterfaceId -----
    SynViewStatus = LvInterfaceOpen(m_hSystem, "%%INTERFACE_ID%%", &hInterface);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenInterface=ByInterfaceTlType -
    char InterfaceId[256];
    SynViewStatus = LvSystemFindInterface(m_hSystem, LvFindBy_TLType, "%%INTERFACE_TLTYPE%%", InterfaceId, sizeof(InterfaceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvInterfaceOpen(m_hSystem, InterfaceId, &hInterface);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------

    LvInterfaceUpdateDeviceList(hInterface);
    --- %%IF OpenDevice=ByDeviceId -----------
    SynViewStatus = LvDeviceOpen(hInterface, "%%DEVICE_ID%%", &hDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenDevice=ByDeviceModelName ----
    char DeviceId[256];
    SynViewStatus = LvInterfaceFindDevice(hInterface, LvFindBy_ModelName, "%%DEVICE_MODELNAME%%", DeviceId, sizeof(DeviceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvDeviceOpen(hInterface, DeviceId, &hDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenDevice=ByDeviceIpAddress ----
    char DeviceId[256];
    SynViewStatus = LvInterfaceFindDevice(hInterface, LvFindBy_GevIPAddress, "%%DEVICE_IPADDRESS%%", DeviceId, sizeof(DeviceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvDeviceOpen(hInterface, DeviceId, &hDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF OpenDevice=ByDeviceUserId -------
    char DeviceId[256];
    SynViewStatus = LvInterfaceFindDevice(hInterface, LvFindBy_UserID, "%%DEVICE_USERID%%", DeviceId, sizeof(DeviceId));
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvDeviceOpen(hInterface, DeviceId, &hDevice, LvDeviceAccess_Control);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF Sys.AutoLoadedCfg=1 -------------
    // Note: When the code was generated, in SynView Explorer was switched ON the option
    // to autoload the camera settings after opening the camera. For this reason the following
    // line loads the camera settings from the file to assure the same starting status.
    --- %%ENDIF ------------------------------
    --- %%IF Sys.SnippetFile=1 ---------------
    SynViewStatus = LvDeviceLoadSettings(hDevice, "", "%%Sys.CameraCfgFile%%", LvSaveFlag_All);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------

    --- %%IF Snippet=All ---------------------
    // The #error line below is intentionally inserted to the code in case you
    // generate the code from streamable or all writable features.
    #error Review the feature settings code and remove the unnecessary items!
    // Before removing this line from the code, go carefully through all the feature
    // settings below and leave there only those, which really need to be set.

    --- %%ENDIF ------------------------------
    --- %%IF Snippet=Streamable --------------
    // The #error line below is intentionally inserted to the code in case you
    // generate the code from streamable or all writable features.
    #error Review the feature settings code and remove the unnecessary items!
    // Before removing this line from the code, go carefully through all the feature
    // settings below and leave there only those, which really need to be set.

    --- %%ENDIF ------------------------------
    %%CameraRemoteFeaturesCode%%

    m_hInterface = hInterface;
    m_hDevice = hDevice;

    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkModeActive, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%IF CHUNK_ENABLED OffsetX ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_OffsetX);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED OffsetY ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_OffsetY);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Width ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_Width);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Height ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_Height);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED PixelFormat ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_PixelFormat);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LinePitch ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_LinePitch);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED FrameID ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_FrameID);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Timestamp ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_Timestamp);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED ExposureTime ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_ExposureTime);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Gain ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_Gain);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LineStatusAll ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_LineStatusAll);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LvExternalADCValue ---
    SynViewStatus = LvSetEnum (m_hDevice, LvDevice_ChunkSelector, LvChunkSelector_LvExternalADCValue);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvSetBool(m_hDevice, LvDevice_ChunkEnable, 1);
    if (ErrorOccurred(SynViewStatus)) return;
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------

    --- %%IF IncUniImgPreprocess=1 -----------
    SynViewStatus = LvSetEnum(m_hDevice, LvDevice_LvUniProcessMode, LvUniProcessMode_Auto);
    if (ErrorOccurred(SynViewStatus)) return;
    SetOptimalUniPixelFormat();
    --- %%ENDIF ------------------------------
    SynViewStatus = LvStreamOpen(m_hDevice, "", &m_hStream);
    if (ErrorOccurred(SynViewStatus)) return;

    SynViewStatus = LvEventOpen(m_hStream, LvEventType_NewBuffer, &m_hNewBufferEvent);
    if (ErrorOccurred(SynViewStatus)) return;
    if (!ReallocateBuffers()) return;
    
    SynViewStatus = LvRendererOpen(m_hStream, &m_hRenderer);
    if (ErrorOccurred(SynViewStatus)) return;
    #ifdef _WIN32
        LvSetEnum(m_hRenderer, LvRenderer_LvRenderType, LvRenderType_ScaleToTiles);
        LvSetInt32(m_hRenderer, LvRenderer_LvNumberOfTiles, g_iNumberOfTiles);                            
        LvSetEnum(m_hRenderer, LvRenderer_LvRenderType, LvRenderType_FullSize);
        if (ErrorOccurred(SynViewStatus)) return;
    #endif
   
    // To be able to display all tiles, we need to delay the return of the buffers
    // to the input buffer pool
    LvSetInt32(m_hStream, LvStream_LvPostponeQueueBuffers, g_iNumberOfTiles);              
    if (ErrorOccurred(SynViewStatus)) return;

    SynViewStatus = LvEventSetCallbackNewBuffer(m_hNewBufferEvent, CallbackNewBufferFunction, this);
    if (ErrorOccurred(SynViewStatus)) return;

    m_pWidgetPaint = new CWidgetPaint();
    m_pWidgetPaint->SetRenderer(m_hRenderer);
    m_pScrollAreaImage->setWidget(m_pWidgetPaint);
}

//-----------------------------------------------------------------------------
// Reallocates the buffers, if the payload size changes

bool CCamera::ReallocateBuffers()
{
    LvStatus SynViewStatus;
    int iPayloadSize;
    SynViewStatus = LvGetInt32(m_hStream, LvStream_LvCalcPayloadSize, &iPayloadSize);
    if (ErrorOccurred(SynViewStatus)) return false;
    if (iPayloadSize != m_iPayloadSize)
    {
        // buffers are either not yet allocated, or something has changed, so there is a need to reallocate
        LvStreamFlushQueue(m_hStream, LvQueueOperation_AllDiscard);
        for (int i=0; i<(int)m_hBufferVector.size(); i++)
        {
            LvHBuffer hBuffer = m_hBufferVector[i];
            if (g_bUseOwnBuffers)
            {
                void* pDataPointer = NULL;
                LvGetPtr (hBuffer, LvBuffer_Base, &pDataPointer);
                if (pDataPointer != NULL) free(pDataPointer);
            }
            SynViewStatus = LvBufferClose(&hBuffer);
            if (ErrorOccurred(SynViewStatus)) return false;
        }
        m_hBufferVector.clear();
        m_iPayloadSize = iPayloadSize;
        for (int i=0; i<g_iNumberOfBuffers; i++) 
        {
            LvHBuffer hBuffer;
            if (g_bUseOwnBuffers)
            {
                void* pDataPointer = calloc(1, m_iPayloadSize);
                if (pDataPointer == NULL)
                {
                    char szMsg[256];
                    sprintf(szMsg, "Failed to allocate %d bytes for image buffer.", m_iPayloadSize);
                    QMessageBox::critical(m_pMainWindow, "Error", szMsg);
                    return false;
                }
                SynViewStatus = LvBufferOpen(m_hStream, pDataPointer, m_iPayloadSize, NULL, 0, &hBuffer);
            }
            else
            {
                SynViewStatus = LvBufferOpen(m_hStream, NULL, 0, NULL, 0, &hBuffer);
            }
            if (ErrorOccurred(SynViewStatus)) return false;
            m_hBufferVector.push_back(hBuffer);
            SynViewStatus = LvBufferQueue(hBuffer);
            if (ErrorOccurred(SynViewStatus)) return false;
        }
        int PostponeBuffers = g_iNumberOfTiles;
        if ((PostponeBuffers+2) > g_iNumberOfBuffers) 
            PostponeBuffers = g_iNumberOfBuffers - 2;
        if (PostponeBuffers < 1) 
            PostponeBuffers = 1;

        // this needs to be done after any buffer allocation
        LvSetInt32(m_hStream, LvStream_LvPostponeQueueBuffers, 0);   
        if (PostponeBuffers > 0) 
            LvSetInt32(m_hStream, LvStream_LvPostponeQueueBuffers, PostponeBuffers);              
    }
    else
    {
        // Payload size not changed
    }
    return true;
}

//-----------------------------------------------------------------------------

void CCamera::StartAcquisition()
{
    if (m_hDevice == 0) return;
    LvStatus SynViewStatus;
    m_pWidgetPaint->SetImageParam(m_hDevice);
    m_dwFrameCounter = 0;
    m_dwFrameCounterForFps = 0;
    if (!ReallocateBuffers()) return;
    SynViewStatus = LvEventStartThread(m_hNewBufferEvent);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvDeviceAcquisitionStart(m_hDevice);
    if (ErrorOccurred(SynViewStatus)) return;
    m_bAcquisitionStarted = true;
}

//-----------------------------------------------------------------------------

void CCamera::StopAcquisition()
{
    if (!m_bAcquisitionStarted) return;
    LvStatus SynViewStatus;
    SynViewStatus = LvDeviceAcquisitionStop(m_hDevice);
    if (ErrorOccurred(SynViewStatus)) return;
    m_bAcquisitionStarted = false;
    SynViewStatus = LvStreamFlushQueue(m_hStream, LvQueueOperation_AllToInput);
    if (ErrorOccurred(SynViewStatus)) return;
    SynViewStatus = LvEventStopThread(m_hNewBufferEvent);
    if (ErrorOccurred(SynViewStatus)) return;
    m_dwFrameCounterForFps = 0;
}

//-----------------------------------------------------------------------------

void CCamera::DisconnectCamera()
{
    if (m_hDevice == 0) return;
    LvStatus SynViewStatus;
    StopAcquisition();
    if (m_hNewBufferEvent != 0)
    {
        SynViewStatus = LvEventClose(&m_hNewBufferEvent);
        if (ErrorOccurred(SynViewStatus)) return;
    }
    if (m_hRenderer != 0)
    {
        SynViewStatus = LvRendererClose(&m_hRenderer);
        if (ErrorOccurred(SynViewStatus)) return;
    }

    LvStreamFlushQueue(m_hStream, LvQueueOperation_AllDiscard);
    for (int i=0; i<(int)m_hBufferVector.size(); i++)
    {
        LvHBuffer hBuffer = m_hBufferVector[i];
        if (g_bUseOwnBuffers)
        {
            void* pDataPointer;
            LvGetPtr (hBuffer, LvBuffer_Base, &pDataPointer);
            if (pDataPointer != NULL) free(pDataPointer);
        }
        LvBufferClose(&hBuffer);
    }
    m_hBufferVector.clear();
    m_iPayloadSize = 0;
    if (m_hStream != 0)
    {
        SynViewStatus = LvStreamClose(&m_hStream);
        if (ErrorOccurred(SynViewStatus)) return;
        m_hStream = 0;
    }
    if (m_hDevice != 0)
    {
        SynViewStatus = LvDeviceClose(&m_hDevice);
        if (ErrorOccurred(SynViewStatus)) return;
        m_hDevice = 0;
    }
    if (m_hInterface != 0)
    {
        SynViewStatus = LvInterfaceClose(&m_hInterface);
        if (ErrorOccurred(SynViewStatus)) return;
        m_hInterface = 0;
    }
    m_pScrollAreaImage->takeWidget();
    delete m_pWidgetPaint;
    m_pWidgetPaint = NULL;
    m_hLastBuffer = 0;
}

//-----------------------------------------------------------------------------

bool CCamera::IsConnected()
{
    return m_hDevice != 0;
}

//-----------------------------------------------------------------------------

bool CCamera::IsAcquiring()
{
    if (m_hDevice == 0) return false;
    int32_t iIsAcquiring;
    LvGetInt32(m_hDevice, LvDevice_LvDeviceIsAcquiring, &iIsAcquiring);
    return iIsAcquiring != 0;
}

--- %%IF IncSimpleImgProcess=1 -----------
//-----------------------------------------------------------------------------

void CCamera::SetProcessing(bool bDoProcessing)
{
    m_bDoProcessing = bDoProcessing;
}

--- %%ENDIF ------------------------------
//-----------------------------------------------------------------------------

void CCamera::CallbackNewBuffer(LvHBuffer hBuffer, void* /* pUserPointer */)
{
    m_dwFrameCounterForFps++;
    m_dwFrameCounter++;
    CalculateFramesPerSecond();

    // Hint: In case you need to check if the image is complete, use this:
    // int32_t IsIncomplete;
    // LvGetBool(hBuffer, LvBuffer_IsIncomplete, &IsIncomplete);

    --- %%IF IncSimpleImgProcess=1 -----------
    // get the pointer to the image data
    void* pData = NULL;
    int32_t iImageOffset = 0;
    --- %%IF IncUniImgPreprocess=1 ------------------
    LvGetPtr (hBuffer, LvBuffer_UniBase, &pData);
    LvGetInt32 (hBuffer, LvBuffer_UniImageOffset, &iImageOffset);
    --- %%ELSE --------------------------------------
    LvGetPtr (hBuffer, LvBuffer_Base, &pData);
    LvGetInt32 (hBuffer, LvBuffer_ImageOffset, &iImageOffset);
    --- %%ENDIF -------------------------------------
    pData = (uint8_t*)pData + iImageOffset;
    if (m_bDoProcessing && pData != NULL)
    {
        // we will do some easy processing - invert the pixel values in an area
        int32_t iWidth;
        int32_t iHeight;
        int32_t iLinePitch;
        LvEnum iPixelFormat;    // LvPixelFormat enumeration value
        LvGetInt32(m_hDevice, LvDevice_Width, &iWidth);
        LvGetInt32(m_hDevice, LvDevice_Height, &iHeight);
        --- %%IF IncUniImgPreprocess=1 -----------
        LvGetEnum(m_hDevice, LvDevice_LvUniPixelFormat, &iPixelFormat);
        LvGetInt32(m_hDevice, LvDevice_LvUniLinePitch, &iLinePitch);
        int32_t iBytesPerPixel = ((iPixelFormat & LV_PIX_EFFECTIVE_PIXEL_SIZE_MASK) >> LV_PIX_EFFECTIVE_PIXEL_SIZE_SHIFT) / 8;
        --- %%ELSE -------------------------------
        LvGetEnum(m_hDevice, LvDevice_PixelFormat, &iPixelFormat);
        int iBitsPerPixel = (iPixelFormat & LV_PIX_EFFECTIVE_PIXEL_SIZE_MASK) >> LV_PIX_EFFECTIVE_PIXEL_SIZE_SHIFT;
        iLinePitch = ((iWidth * iBitsPerPixel)+7)/8;
        int32_t iBytesPerPixel = iBitsPerPixel / 8;
        --- %%ENDIF ------------------------------

        for (int32_t j=0; j<(iHeight/2); j++)
        {
            uint8_t* pPixel = ((uint8_t*)pData) + (iHeight/4 + j)*iLinePitch + (iWidth/4)*iBytesPerPixel;
            for (int32_t i=0; i<(iWidth/2); i++)
            {
                for (int32_t k=0; k<iBytesPerPixel; k++)
                {
                    *pPixel = ~*pPixel;
                    pPixel++;
                }
            }
        }
    }
    --- %%ELSE -------------------------------
    // no image processing demonstrated - switch it ON in the code generation Wizard if you need it
    --- %%ENDIF ------------------------------

    --- %%IF IncChunkData=1 ------------------
    --- %%IF FEATURE ChunkModeActive ---
    // before the chunk data can be read for this buffer, they must be parsed.
    LvBufferParseChunkData(hBuffer);
    int64_t ChunkValue;
    char szChunkLine[256];
    szChunkLine[0] = 0;
    char szValue[128];
    --- %%IF CHUNK_ENABLED OffsetX ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkOffsetX, &ChunkValue);
    sprintf(szValue, "X=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED OffsetY ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkOffsetY, &ChunkValue);
    sprintf(szValue, "Y=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Width ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkWidth, &ChunkValue);
    sprintf(szValue, "W=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Height ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkHeight, &ChunkValue);
    sprintf(szValue, "H=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED PixelFormat ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkPixelFormat, &ChunkValue);
    sprintf(szValue, "PF=0x%llx | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LinePitch ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkLinePitch, &ChunkValue);
    sprintf(szValue, "LPitch=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED FrameID ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkFrameID, &ChunkValue);
    sprintf(szValue, "FrameID=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Timestamp ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkTimestamp, &ChunkValue);
    sprintf(szValue, "Time=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED ExposureTime ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkExposureTime, &ChunkValue);
    sprintf(szValue, "Exp=%lld | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED Gain ---
    // the LvIsAvailableEnumEntry() is time consuming, better if you move it outside this callback
    if (LvIsAvailableEnumEntry(m_hDevice, LvDevice_ChunkGainSelector, LvChunkGainSelector_AnalogAll) != 0)
    {
        LvSetEnum (m_hDevice, LvDevice_ChunkGainSelector, LvChunkGainSelector_AnalogAll);
        LvGetInt64 (m_hDevice, LvDevice_ChunkGain, &ChunkValue);
        sprintf(szValue, "GainA=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (LvIsAvailableEnumEntry(m_hDevice, LvDevice_ChunkGainSelector, LvChunkGainSelector_DigitalAll) != 0)
    {
        LvSetEnum (m_hDevice, LvDevice_ChunkGainSelector, LvChunkGainSelector_DigitalAll);
        LvGetInt64 (m_hDevice, LvDevice_ChunkGain, &ChunkValue);
        sprintf(szValue, "GainD=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LineStatusAll ---
    LvGetInt64 (m_hDevice, LvDevice_ChunkLineStatusAll, &ChunkValue);
    sprintf(szValue, "Line=0x%llx | ", ChunkValue);
    strcat(szChunkLine, szValue);
    --- %%ENDIF ------------------------------
    --- %%IF CHUNK_ENABLED LvExternalADCValue ---
    // the LvIsAvailableEnumEntry() is time consuming, better if you move it outside this callback
    if (LvIsAvailableEnumEntry(m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC1) != 0)
    {
        LvSetEnum (m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC1);
        LvGetInt64 (m_hDevice, LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC1=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (LvIsAvailableEnumEntry(m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC2) != 0)
    {
        LvSetEnum (m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC2);
        LvGetInt64 (m_hDevice, LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC2=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (LvIsAvailableEnumEntry(m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC3) != 0)
    {
        LvSetEnum (m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC3);
        LvGetInt64 (m_hDevice, LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC3=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    if (LvIsAvailableEnumEntry(m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC4) != 0)
    {
        LvSetEnum (m_hDevice, LvDevice_ChunkLvExternalADCSelector, LvChunkLvExternalADCSelector_ExternalADC4);
        LvGetInt64 (m_hDevice, LvDevice_ChunkLvExternalADCValue, &ChunkValue);
        sprintf(szValue, "ADC4=%lld | ", ChunkValue);
        strcat(szChunkLine, szValue);
    }
    --- %%ENDIF ------------------------------
    // m_szChunkLine is read from another thread, so make its filling safe
    memset(m_szChunkLine, 0, sizeof(m_szChunkLine));
    strcpy(m_szChunkLine, szChunkLine);
    --- %%ENDIF ------------------------------
    --- %%ENDIF ------------------------------

    m_pWidgetPaint->DisplayImageFromAnotherThread(m_hStream, hBuffer);
    m_hLastBuffer = hBuffer;
    LvBufferQueue(hBuffer);
}

//-----------------------------------------------------------------------------

void CCamera::SetRenderType(LvRenderType RenderType)
{
    m_RenderType = RenderType;
    m_pWidgetPaint->SetRenderType(RenderType);
}

//-----------------------------------------------------------------------------

LvRenderType CCamera::GetRenderType()
{
    return m_RenderType;
}

//-----------------------------------------------------------------------------

uint32_t CCamera::GetFrameCount()
{
    return m_dwFrameCounter;
}

//-----------------------------------------------------------------------------

double CCamera::CalculateFramesPerSecond()
{
    uint32_t dwCurrentTime = OsGetTickCount();
    if (dwCurrentTime > m_dwGrabStartTimeForFps && 
        (dwCurrentTime >= (m_dwGrabStartTimeForFps + 3000) ||
         m_dwFrameCounterForFps > 200))
    {
        if (m_dwFrameCounterForFps == 0)
            m_dFramesPerSec = 0;
        else
            m_dFramesPerSec = (((double)m_dwFrameCounterForFps + 0.5)*1000) / (double)(dwCurrentTime - m_dwGrabStartTimeForFps);
        m_dwFrameCounterForFps = 0;
        m_dwGrabStartTimeForFps = dwCurrentTime;
    }
    return m_dFramesPerSec;
}

--- %%IF IncUniImgPreprocess=1 -----------
//-----------------------------------------------------------------------------
// Determines optimal pixel format for the uni-process

void CCamera::SetOptimalUniPixelFormat()
{
    LvEnum PixelFormat;
    LvGetEnum(m_hDevice, LvDevice_PixelFormat, &PixelFormat);
    LvEnum UniPixelFormat = PixelFormat;
    switch (PixelFormat)
    {
        case LvPixelFormat_Mono8:
        case LvPixelFormat_Mono10:
        case LvPixelFormat_Mono12:
        case LvPixelFormat_Mono16:
            UniPixelFormat = LvPixelFormat_Mono8;
            break;

        case LvPixelFormat_BayerGR8:
        case LvPixelFormat_BayerRG8:
        case LvPixelFormat_BayerGB8:
        case LvPixelFormat_BayerBG8:
        case LvPixelFormat_BayerGR10:
        case LvPixelFormat_BayerRG10:
        case LvPixelFormat_BayerGB10:
        case LvPixelFormat_BayerBG10:
        case LvPixelFormat_BayerGR12:
        case LvPixelFormat_BayerRG12:
        case LvPixelFormat_BayerGB12:
        case LvPixelFormat_BayerBG12:
        case LvPixelFormat_RGB8Packed:
        case LvPixelFormat_RGBA8Packed:
            UniPixelFormat = LvPixelFormat_BGRA8Packed;
            break;
    }
    LvSetEnum(m_hDevice, LvDevice_LvUniPixelFormat, UniPixelFormat);
}

--- %%ENDIF ------------------------------
--- %%IF IncChunkData=1 ------------------
--- %%IF FEATURE ChunkModeActive ---
//-----------------------------------------------------------------------------
char* CCamera::GetChunkDataString()
{
    return m_szChunkLine;
}
--- %%ENDIF ------------------------------
--- %%ENDIF ------------------------------
//-----------------------------------------------------------------------------


