#ifndef _PAINT_H
#define _PAINT_H

#include <QWidget>
#include <QPixmap>
#include <QPainter>
#include <QPaintEvent>
#include <QPaintEngine>

#include <sv.synview.class.h>

class CWidgetPaint : public QWidget
{
    Q_OBJECT
public:
    CWidgetPaint(QWidget *parent = 0);
    ~CWidgetPaint();
    virtual QPaintEngine* paintEngine() const;
    void SetImageParam(LvDevice* pDevice);
    void DisplayImageFromAnotherThread(LvStream* pStream, LvBuffer* pBuffer);
    virtual QSize sizeHint() const;
    void SetRenderType(LvRenderType RenderType);

    void SetRenderer(LvRenderer* pRenderer);
    #ifdef USE_IDLE_TIMER
        void Idle();
    #endif

 
protected:
    virtual void paintEvent (QPaintEvent * pEvent);
private:
    LvDevice*     m_pDevice;
    LvStream*     m_pStream;
    LvBuffer*     m_pBuffer;
    LvBuffer*     m_pLastBuffer;
    LvRenderer*   m_pRenderer;
    LvRenderType  m_RenderType;
    WId           m_WinId;
    #ifndef _WIN32
        void*     m_pDisplay;
    #endif
    int32_t       m_iSrcWidth;
    int32_t       m_iSrcHeight;
    int32_t       m_iPaintWidth;   // paint rectangle - if changes, we erase background
    int32_t       m_iPaintHeight;
    bool          m_bBackgroundRepaintNeeded;
    int32_t       m_iLastParentWidth;
    int32_t       m_iLastParentHeight;
    void OsDisplayImage();

};

#endif
