#ifndef SV_SYNVIEW_GEN_H
#define SV_SYNVIEW_GEN_H

#include <sv.synview.defs.h>
#include <sv.synview.enums.h>
#include <sv.synview.status.h>

#ifndef _WIN32
    #include <X11/Xlib.h>
#endif

#ifdef LV_GEN_DLL
    #define LVDSP_DLLENTRY LV_EXTC LV_DLLEXPORT
#else
    #define LVDSP_DLLENTRY LV_EXTC LV_DLLIMPORT
#endif

#define LVGEN_HEXADECIMAL   0x00000001
#define LVGEN_CHECKERROR    0x00000002
#define LVGEN_DUMMYVALUE    0x00000004

#define LVGEN_OPER_MASK     0x00000F00
#define LVGEN_SETVALUE      0x00000100
#define LVGEN_GETVALUE      0x00000200
                                     
#define LVGEN_API_MASK      0x0000F000
#define LVGEN_GENERIC       0x00001000
#define LVGEN_SYMBOLIC      0x00002000
#define LVGEN_NATIVE        0x00003000
                                     
#define LVGEN_LANG_MASK     0x000F0000
#define LVGEN_PLAINC        0x00010000
#define LVGEN_CPP           0x00020000
#define LVGEN_CPPNET        0x00030000
#define LVGEN_CSNET         0x00040000
#define LVGEN_VBNET         0x00050000
#define LVGEN_SMART         0x00060000

#define LVGEN_NEXTCODECOMMENT  0x00100000 // comment displayed only if at least 1 code line follows
#define LVGEN_ADDLINEAFTERDECL 0x00200000 // add empty line between declarations and code
#define LVGEN_USEHTML          0x00400000 // add HTML tags
#define LVGEN_COMMENTOUTCODE   0x00800000 // code is created, but commented out


typedef void* LvHSource;

LVDSP_DLLENTRY LvStatus LV_STDC LvGenCreate (const char* pTemplateFileName, LvHSource* phSource);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenClose (LvHSource hSource);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenClearAll (LvHSource hSource);

LVDSP_DLLENTRY LvStatus LV_STDC LvGenSetModules (LvHSource hSource, LvHSystem hSystem, LvHInterface hInterface, LvHDevice hDevice);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddOpenInterfaceDevice (LvHSource hSource, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddBool (LvHSource hSource, LvHModule hModule, LvFeature Item, int32_t Value, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddInt32 (LvHSource hSource, LvHModule hModule, LvFeature Item, int32_t Value, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddInt64 (LvHSource hSource, LvHModule hModule, LvFeature Item, int64_t Value, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddFloat (LvHSource hSource, LvHModule hModule, LvFeature Item, double Value, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddString (LvHSource hSource, LvHModule hModule, LvFeature Item, const char* pValue, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddEnum   (LvHSource hSource, LvHModule hModule, LvFeature Item, const char* pSymbolicValueName, const char* pEnumValueName, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddBuffer (LvHSource hSource, LvHModule hModule, LvFeature Item, void* pBuffer, size_t Size, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddCmdExecute (LvHSource hSource, LvHModule hModule, LvFeature Item, uint32_t Options);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenAddComment (LvHSource hSource, const char* pComment, uint32_t Options);

LVDSP_DLLENTRY LvStatus LV_STDC LvGenGetSourceSize (LvHSource hSource, size_t* pSize, uint32_t Options, uint32_t iIndent=0);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenGetSource (LvHSource hSource, char* pszText, size_t Size, uint32_t Options, uint32_t iIndent=0);

LVDSP_DLLENTRY LvStatus LV_STDC LvGenGetNotesSize (LvHSource hSource, size_t* pSize, uint32_t Options, uint32_t iIndent=0);
LVDSP_DLLENTRY LvStatus LV_STDC LvGenGetNotes (LvHSource hSource, char* pszText, size_t Size, uint32_t Options, uint32_t iIndent=0);


#endif
