#define _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_DEPRECATE

#define SIMPLON_CLASS_IMPLEMENTATION
#include "sv.synview.class.h"
#include "sv.synview.h"

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>


// tbd: add FW update functions

bool g_bThrowErrorEnable = false;

/*** General functions ********************************************************/

#ifndef LV_USE_STDEXCEPTION

    LvException::LvException(const char* pMessage, LvStatus Number) throw()
    {
        #ifdef USE_STATIC_MSG
            memset(m_szMessage, 0, sizeof(m_szMessage));
            size_t Length = 0;
            if (pMessage != NULL)
                Length = strlen(pMessage);
            if (Length >= sizeof(m_szMessage))
                Length = sizeof(m_szMessage)-1;
            if (pMessage != NULL)
                strncpy(m_szMessage, pMessage, Length);
        #else
            size_t Size = 1;
            if (pMessage != NULL)
                Size = strlen(pMessage) + 1;
            m_pMessage = (char*) calloc(1, Size);
            if (m_pMessage != NULL)
            {
                if (pMessage != NULL)
                    strcpy(m_pMessage, pMessage);
                else
                    m_pMessage[0]=0;
            }
        #endif
        m_Number = Number;
    }


    #ifndef USE_STATIC_MSG
    // copy constructor is necessary
    LvException::LvException(const LvException& e) throw()
    {
        size_t Size = 1;
        if (e.m_pMessage != NULL)
            Size = strlen(e.m_pMessage) + 1;
        m_pMessage = (char*) calloc(1, Size);
        if (m_pMessage != NULL)
        {
            if (e.m_pMessage != NULL)
                strcpy(m_pMessage, e.m_pMessage);
            else
                m_pMessage[0]=0;
        }
        m_Number = e.m_Number;
    }
    #endif


    LvException::~LvException() throw()
    {
        #ifndef USE_STATIC_MSG
            if (m_pMessage != NULL) 
                free(m_pMessage);
        #endif
    }


    const char* LvException::Message() throw()
    {
        #ifdef USE_STATIC_MSG
            return m_szMessage;
        #else
            static char* pEmpty = (char*)"";
            return m_pMessage != NULL ? m_pMessage : pEmpty;
        #endif
    }


    LvStatus LvException::Number() throw()
    {
        return m_Number;
    }

    #define RETURN(x)                                                             \
        {                                                                         \
            LvStatus _xStatus = x;                                                \
            if (g_bThrowErrorEnable)                                              \
            {                                                                     \
                if (_xStatus != LVSTATUS_OK)                                      \
                {                                                                 \
                    char _szError[2048];                                          \
                    LvGetLastErrorMessage (_szError, sizeof(_szError));           \
                    char _szMessage[3072];                                        \
                    sprintf(_szMessage, "%s: %s", __FUNCTION__, _szError);        \
                    throw LvException(_szMessage, _xStatus);                      \
                }                                                                 \
            }                                                                     \
            return _xStatus;                                                      \
        }

#else

    #define RETURN(x)                                                             \
        {                                                                         \
            LvStatus _xStatus = x;                                                \
            if (g_bThrowErrorEnable)                                              \
            {                                                                     \
                if (_xStatus != LVSTATUS_OK)                                      \
                {                                                                 \
                    char _szError[2048];                                          \
                    LvGetLastErrorMessage (_szError, sizeof(_szError));           \
                    char _szMessage[3072];                                        \
                    sprintf(_szMessage, "%s: %s", __FUNCTION__, _szError);        \
                    throw std::exception(_szMessage);                             \
                }                                                                 \
            }                                                                     \
            return _xStatus;                                                      \
        }

#endif


#ifdef LV_USE_STDLIB

//-----------------------------------------------------------------------------

std::string LvGetErrorMessage (LvStatus iError)
{ 
    char szText[2048];
    LvGetErrorMessage (iError, szText, sizeof(szText));
    return szText;
}

//-----------------------------------------------------------------------------

std::string LvGetLastErrorMessage ()
{ 
    char szText[2048];
    LvGetLastErrorMessage (szText, sizeof(szText));
    return szText;
}

//-----------------------------------------------------------------------------

LvStatus LvGetLibInfoStr (LvEnum Info, std::string& sInfo, int32_t Param)
{
    size_t iSize;
    sInfo = "";
    LvStatus TlStatus;
    TlStatus = LvGetLibInfoStrSize (Info, &iSize, Param);
    if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
    char* pszText = new char[iSize];
    TlStatus = LvGetLibInfoStr (Info, pszText, iSize, Param);
    sInfo = pszText;
    delete[] pszText;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvGetSystemId (uint32_t Index, std::string& sSystemId)
{
    size_t iSize;
    sSystemId = "";
    LvStatus TlStatus;
    TlStatus = LvGetSystemIdSize (Index, &iSize);
    if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
    char* pszText = new char[iSize];
    TlStatus = LvGetSystemId (Index, pszText, iSize);
    sSystemId = pszText;
    delete[] pszText;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

#endif

//*** LvLibrary ****************************************************************

uint32_t LvLibrary::GetVersion()
{
    return LvGetVersion();
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::OpenLibrary()
{
    RETURN(LvOpenLibrary());
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::CloseLibrary()
{
    RETURN(LvCloseLibrary());
}

//-----------------------------------------------------------------------------

void LvLibrary::GetErrorMessage (LvStatus Error, char* pMessage, size_t Size)
{
    LvGetErrorMessage (Error, pMessage, Size);
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
    std::string LvLibrary::GetErrorMessage(LvStatus Error)
    {
        char szText[2048];
        LvGetErrorMessage (Error, szText, sizeof(szText));
        return szText;
    }
#endif

//-----------------------------------------------------------------------------

void LvLibrary::GetLastErrorMessage (char* pMessage, size_t Size)
{
    LvGetLastErrorMessage (pMessage, Size);
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
    std::string LvLibrary::GetLastErrorMessage()
    {
        char szText[2048];
        LvGetLastErrorMessage (szText, sizeof(szText));
        return szText;
    }
#endif

//-----------------------------------------------------------------------------

void LvLibrary::Log(const char* pLogMessage)
{
    LvLog(pLogMessage);
}

//-----------------------------------------------------------------------------

void LvLibrary::Logf(const char* pszFormat, ...)
{
    va_list args;
    char szText[2048];
    va_start(args, pszFormat);
    vsnprintf(szText, sizeof(szText), pszFormat, args);
    va_end(args);
    LvLog(szText);
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::GetLibInfo(LvEnum Info, int32_t* pInfo, int32_t Param )
{
    RETURN(LvGetLibInfo(Info, pInfo, Param));
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::GetLibInfoStr (LvEnum Info, char* pInfoStr, size_t Size, int32_t Param)
{
    RETURN(LvGetLibInfoStr (Info, pInfoStr, Size, Param));
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::GetLibInfoStrSize (LvEnum Info, size_t* pSize, int32_t Param)
{
    RETURN(LvGetLibInfoStrSize (Info, pSize, Param));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
    LvStatus LvLibrary::GetLibInfoStr (LvEnum Info, std::string& sInfo, int32_t Param)
    {
        size_t iSize;
        sInfo = "";
        LvStatus TlStatus;
        TlStatus = LvGetLibInfoStrSize (Info, &iSize, Param);
        if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
        char* pszText = new char[iSize];
        TlStatus = LvGetLibInfoStr (Info, pszText, iSize, Param);
        sInfo = pszText;
        delete[] pszText;
        RETURN(TlStatus);
    }
#endif

//-----------------------------------------------------------------------------

LvStatus LvLibrary::UpdateSystemList()
{
    RETURN(LvUpdateSystemList());
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::GetNumberOfSystems(uint32_t* pNumberOfSystems)
{
    RETURN(LvGetNumberOfSystems(pNumberOfSystems));
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::GetSystemId (uint32_t Index, char* pSystemId, size_t Size)
{
    RETURN(LvGetSystemId(Index, pSystemId, Size));
}

//-----------------------------------------------------------------------------

LvStatus LvLibrary::GetSystemIdSize (uint32_t Index, size_t* pSize)
{
    RETURN(LvGetSystemIdSize(Index, pSize));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
    LvStatus LvLibrary::GetSystemId (uint32_t Index, std::string& sSystemId)
    {
        size_t iSize;
        sSystemId = "";
        LvStatus TlStatus;
        TlStatus = LvGetSystemIdSize (Index, &iSize);
        if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
        char* pszText = new char[iSize];
        TlStatus = LvGetSystemId (Index, pszText, iSize);
        sSystemId = pszText;
        delete[] pszText;
        RETURN(TlStatus);
    }
#endif

//-----------------------------------------------------------------------------

void LvLibrary::SetThrowErrorEnable(bool bEnable)
{
    g_bThrowErrorEnable = bEnable;
}

//-----------------------------------------------------------------------------

LvLibrary::LvLibrary()
{
}

//-----------------------------------------------------------------------------

LvLibrary::~LvLibrary()
{
}

 
//*** LvModule ****************************************************************

LvStatus LvModule::GetNumFeatures (LvFtrGroup FtrGroup, uint32_t* pdwNumFeatures)
{
    RETURN(LvGetNumFeatures (m_hModule, FtrGroup, pdwNumFeatures));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetFeatureAt (LvFtrGroup FtrGroup,
                                   uint32_t dwIndex, 
                                   LvFeature* pFeature,
                                   uint32_t* pdwLevel)
{
    RETURN(LvGetFeatureAt (m_hModule, FtrGroup, dwIndex, pFeature, pdwLevel));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetFeatureByName (LvFtrGroup FtrGroup, 
                                     const char* pszName, 
                                     LvFeature* pFeature)
{
    RETURN(LvGetFeatureByName (m_hModule, FtrGroup, pszName, pFeature));
}

//-----------------------------------------------------------------------------

bool LvModule::IsImplemented (LvFeature Feature)
{
    return LvIsImplemented (m_hModule, Feature) != 0;
}

//-----------------------------------------------------------------------------

bool LvModule::IsImplementedByName (LvEnum FeatureGroup,
                                    const char* pName)
{
    return LvIsImplementedByName (m_hModule, FeatureGroup, pName) != 0;
}

//-----------------------------------------------------------------------------

bool LvModule::IsAvailable (LvFeature Feature)
{
    return LvIsAvailable (m_hModule, Feature) != 0;
}

//-----------------------------------------------------------------------------

bool LvModule::IsAvailableByName (LvEnum FeatureGroup,
                                  const char* pName)
{
    return LvIsAvailableByName (m_hModule, FeatureGroup, pName) != 0;
}

//-----------------------------------------------------------------------------

bool LvModule::IsReadable (LvFeature Feature)
{
    return LvIsReadable (m_hModule, Feature) != 0;
}

//-----------------------------------------------------------------------------

bool LvModule::IsWritable (LvFeature Feature)
{
    return LvIsWritable (m_hModule, Feature) != 0;
}

//-----------------------------------------------------------------------------

bool LvModule::IsAvailableEnumEntry (LvFeature Feature, LvEnum EnumEntry)
{
    return LvIsAvailableEnumEntry (m_hModule, Feature, EnumEntry) != 0;
}

//-----------------------------------------------------------------------------

bool LvModule::IsImplementedEnumEntry (LvFeature Feature, LvEnum EnumEntry)
{
    return LvIsImplementedEnumEntry (m_hModule, Feature, EnumEntry) != 0;
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetType (LvFeature Feature, 
                            LvFtrType* pFeatureType, 
                            LvFtrGui* pFeatureGuiCtl,
                            LvFtrGroup* pFtrGroup)
{
    LvEnum FeatureType;
    LvEnum FeatureGuiCtl;
    LvEnum FeatureGroup;
    LvStatus TlStatus = LvGetType (m_hModule, Feature, &FeatureType, &FeatureGuiCtl, &FeatureGroup);
    if (pFeatureType   != NULL) *pFeatureType   = (LvFtrType)FeatureType;
    if (pFeatureGuiCtl != NULL) *pFeatureGuiCtl = (LvFtrGui)FeatureGuiCtl;
    if (pFtrGroup      != NULL) *pFtrGroup      = (LvFtrGroup) FeatureGroup;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetBool (LvFeature Feature, 
                            bool* pbValue)
{
    int32_t iValue;
    LvStatus TlStatus = LvGetBool (m_hModule, Feature, &iValue); 
    if (pbValue != NULL) *pbValue = iValue != 0;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetBool (LvFeature Feature, 
                            bool bValue)
{
    RETURN(LvSetBool (m_hModule, Feature, bValue ? 1 : 0));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetInt32 (LvFeature Feature, 
                             int32_t* piValue)
{
    RETURN(LvGetInt32 (m_hModule, Feature, piValue)); 
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetInt32 (LvFeature Feature, 
                             int32_t iValue)
{
    RETURN(LvSetInt32 (m_hModule, Feature, iValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetInt32Range (LvFeature Feature, 
                                  int32_t* piMinValue,
                                  int32_t* piMaxValue,
                                  int32_t* piIncrement)
{
    RETURN(LvGetInt32Range (m_hModule, Feature, piMinValue, piMaxValue, piIncrement));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetInt64 (LvFeature Feature, 
                             int64_t* piValue)
{
    RETURN(LvGetInt64 (m_hModule, Feature, piValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetInt64 (LvFeature Feature, 
                             int64_t iValue)
{
    RETURN(LvSetInt64 (m_hModule, Feature, iValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetInt64Range (LvFeature Feature, 
                                  int64_t* piMinValue,
                                  int64_t* piMaxValue,
                                  int64_t* piIncrement)
{
    RETURN(LvGetInt64Range (m_hModule, Feature, piMinValue, piMaxValue, piIncrement));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetInt (LvFeature Feature, 
                           int64_t* piValue)
{
    RETURN(LvGetInt (m_hModule, Feature, piValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetInt (LvFeature Feature, 
                           int64_t iValue)
{
    RETURN(LvSetInt (m_hModule, Feature, iValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetIntRange (LvFeature Feature, 
                                int64_t* piMinValue,
                                int64_t* piMaxValue,
                                int64_t* piIncrement)
{
    RETURN(LvGetIntRange (m_hModule, Feature, piMinValue, piMaxValue, piIncrement));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetFloat (LvFeature Feature, 
                             double* pValue)
{
    RETURN(LvGetFloat (m_hModule, Feature, pValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetFloat (LvFeature Feature, 
                             double Value)
{
    RETURN(LvSetFloat (m_hModule, Feature, Value));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetFloatRange (LvFeature Feature, 
                                  double* pMinValue,
                                  double* pMaxValue,
                                  double* pIncrement)
{
    RETURN(LvGetFloatRange (m_hModule, Feature, pMinValue, pMaxValue, pIncrement));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvModule::GetString (LvFeature Feature,
                              std::string& sValue)
{
    size_t iSize;
    LvStatus TlStatus;
    TlStatus = LvGetStringSize (m_hModule, Feature, &iSize);
    if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
    char* pszText = new char[iSize];
    TlStatus = LvGetString (m_hModule, Feature, pszText, iSize);
    sValue = pszText;
    delete[] pszText;
    RETURN(TlStatus);
}
#endif

LvStatus LvModule::GetString (LvFeature Feature, 
                              char* pszValue, 
                              size_t iSize)
{
    RETURN(LvGetString (m_hModule, Feature, pszValue, iSize));
}


//-----------------------------------------------------------------------------

LvStatus LvModule::GetStringSize (LvFeature Feature, 
                                  size_t* piSize)
{
    RETURN(LvGetStringSize (m_hModule, Feature, piSize));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetString (LvFeature Feature, 
                              const char* pszValue)
{
    RETURN(LvSetString (m_hModule, Feature, pszValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetBuffer (LvFeature Feature, 
                      void* pBuffer, 
                      size_t Size)
{
    RETURN(LvGetBuffer (m_hModule, Feature, pBuffer, Size));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetBufferSize (LvFeature Feature, 
                                  size_t* pSize)
{
    RETURN(LvGetBufferSize (m_hModule, Feature, pSize));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetBuffer (LvFeature Feature, 
                              void* pBuffer,
                              size_t Size)
{
    RETURN(LvSetBuffer (m_hModule, Feature, pBuffer, Size));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetPtr (LvFeature Feature, 
                           void** ppValue)
{
    RETURN(LvGetPtr (m_hModule, Feature, ppValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetPtr (LvFeature Feature, 
                           void* pValue)
{
    RETURN(LvSetPtr (m_hModule, Feature, pValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetEnum (LvFeature Feature, 
                            LvEnum* piValue)
{
    RETURN(LvGetEnum (m_hModule, Feature, piValue));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetEnum (LvFeature Feature, 
                            LvEnum iValue)
{
    RETURN(LvSetEnum (m_hModule, Feature, iValue));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvModule::GetEnumStr (LvFeature Feature,
                               std::string& sSymbolicName)
{
    size_t iSymbolicNameSize = 2048; // to be faster
    //LvStatus TlStatus = LvGetEnumMaxStrSize (m_hModule, Feature, &iSymbolicNameSize, NULL);
    //if (TlStatus != LVSTATUS_OK || iSymbolicNameSize == 0) RETURN(TlStatus);
    char* pszSymbolicName = new char[iSymbolicNameSize];
    LvStatus TlStatus = LvGetEnumStr (m_hModule, Feature, pszSymbolicName, iSymbolicNameSize);
    sSymbolicName = pszSymbolicName;
    delete[] pszSymbolicName;
    RETURN(TlStatus);
}
#endif

LvStatus LvModule::GetEnumStr (LvFeature Feature, 
                               char* pszSymbolicName,
                               size_t iSize)
{
    RETURN(LvGetEnumStr (m_hModule, Feature, pszSymbolicName, iSize));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::SetEnumStr (LvFeature Feature, 
                               const char* pszSymbolicName)
{
    RETURN(LvSetEnumStr (m_hModule, Feature, pszSymbolicName));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetEnumValByStr (LvFeature Feature, 
                                    const char* pszSymbolicName, 
                                    LvEnum* piValue,
                                    LvFtrAccess* pFeatureAccess)
{
    LvEnum FeatureAccess;
    LvStatus TlStatus = LvGetEnumValByStr (m_hModule, Feature, pszSymbolicName, piValue, &FeatureAccess);
    if (pFeatureAccess != NULL) *pFeatureAccess = (LvFtrAccess)FeatureAccess;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvModule::GetEnumStrByVal (LvFeature Feature,
                                    LvEnum iValue,
                                    std::string& sSymbolicName,
                                    LvFtrAccess* pFeatureAccess)
{
    int32_t iMaxNameSize = 0;
    LvStatus TlStatus = LvGetInfo (m_hModule, Feature, LvFtrInfo_EnumEntryNameMaxSize, &iMaxNameSize);
    if (TlStatus != LVSTATUS_OK || iMaxNameSize == 0) RETURN(TlStatus);
    char* pszSymbolicName = new char[iMaxNameSize];
    LvEnum FeatureAccess;
    TlStatus = LvGetEnumStrByVal (m_hModule, Feature, iValue, pszSymbolicName, iMaxNameSize, &FeatureAccess);
    if (pFeatureAccess != NULL) *pFeatureAccess = (LvFtrAccess)FeatureAccess;
    sSymbolicName = pszSymbolicName;
    delete[] pszSymbolicName;
    RETURN(TlStatus);
}
#endif

LvStatus LvModule::GetEnumStrByVal (LvFeature Feature,
                                    LvEnum iValue,
                                    char* pszSymbolicName, 
                                    size_t iSymbolicNameSize,
                                    LvFtrAccess* pFeatureAccess)
{
    LvEnum FeatureAccess;
    LvStatus TlStatus = LvGetEnumStrByVal (m_hModule, Feature, iValue, pszSymbolicName, iSymbolicNameSize, &FeatureAccess);
    if (pFeatureAccess != NULL) *pFeatureAccess = (LvFtrAccess) FeatureAccess;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvModule::CmdExecute (LvFeature Feature, uint32_t Timeout)
{
    RETURN(LvCmdExecute (m_hModule, Feature, Timeout));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::CmdIsDone (LvFeature Feature, 
                              bool* pbIsDone)
{
    uint32_t bIsDone;
    LvStatus TlStatus = LvCmdIsDone (m_hModule, Feature, &bIsDone); 
    if (pbIsDone != NULL) *pbIsDone = bIsDone != 0;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetAccess (LvFeature Feature,
                              LvFtrAccess* pFeatureAccess)
{
    LvEnum FeatureAccess;
    LvStatus TlStatus = LvGetAccess (m_hModule, Feature, &FeatureAccess);
    if (pFeatureAccess != NULL) *pFeatureAccess = (LvFtrAccess) FeatureAccess;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetVisibility (LvFeature Feature, 
                                  LvFtrVisibility* pFeatureVisibility)
{
    LvEnum FeatureVisibility;
    LvStatus TlStatus = LvGetVisibility (m_hModule, Feature, &FeatureVisibility);
    if (pFeatureVisibility != NULL) *pFeatureVisibility = (LvFtrVisibility) FeatureVisibility;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetInfo (LvFeature Feature, 
                            LvFtrInfo FeatureInfo,
                            int32_t* pInfo, 
                            int32_t Param)
{
    RETURN(LvGetInfo (m_hModule, Feature, FeatureInfo, pInfo, Param));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
  LvStatus LvModule::GetInfoStr (LvFeature Feature, 
                                 LvFtrInfo FeatureInfo,
                                 std::string& sInfoStr,
                                 int32_t Param)
  {
      size_t iSize = 0;
      LvStatus TlStatus;
      TlStatus = LvGetInfoStrSize (m_hModule, Feature, FeatureInfo, &iSize, Param); 
      if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
      char* pszText = new char[iSize];
      TlStatus = LvGetInfoStr (m_hModule, Feature, FeatureInfo, pszText, iSize, Param); 
      sInfoStr = pszText;
      delete[] pszText;
      RETURN(TlStatus);
  }
#endif

LvStatus LvModule::GetInfoStr (LvFeature Feature, 
                               LvFtrInfo FeatureInfo,
                               char* pInfoStr,
                               size_t Size,
                               int32_t Param)
{
    RETURN(LvGetInfoStr (m_hModule, Feature, FeatureInfo, pInfoStr, Size, Param));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::GetInfoStrSize (LvFeature Feature, 
                                   LvFtrInfo FeatureInfo,
                                   size_t* pSize,
                                   int32_t Param)
{
    RETURN(LvGetInfoStrSize (m_hModule, Feature, FeatureInfo, pSize, Param));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::RegisterFeatureCallback(LvFeature Feature,
                                           LvFeatureCallbackFunct pFunction,
                                           void* pUserParam, 
                                           void* pFeatureParam)
                                 
{
    RETURN(LvRegisterFeatureCallback(m_hModule, Feature, pFunction, pUserParam, pFeatureParam));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::StartPollingThread(uint32_t PollingTime,
                                      bool PollChildren)
{
    RETURN(LvStartPollingThread(m_hModule, PollingTime, PollChildren ? 1 : 0));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::StopPollingThread()
{
    RETURN(LvStopPollingThread(m_hModule));
}

//-----------------------------------------------------------------------------

LvStatus LvModule::Poll()
{
    RETURN(LvPoll(m_hModule));
}

/*** LvSystem *****************************************************************/

LvStatus LvSystem::Open (const char* pszSystemId, LvSystem*& pSystem) 
{
    LvHSystem hSystem = 0;
    pSystem = NULL;
    LvStatus TlStatus = LvSystemOpen (pszSystemId, &hSystem);
    if (TlStatus == LVSTATUS_OK)
    {
        pSystem = new LvSystem();
        pSystem->m_hSystem = hSystem;
        pSystem->m_hModule = hSystem;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::Close (LvSystem*& pSystem)
{
    if (pSystem == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvSystemClose (&pSystem->m_hSystem);
    if (TlStatus == LVSTATUS_OK)
    {
        delete pSystem;
        pSystem = NULL;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::UpdateInterfaceList (uint32_t dwTimeout)
{
    RETURN(LvSystemUpdateInterfaceList (m_hSystem, dwTimeout));
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::GetNumberOfInterfaces (uint32_t* pdwNumberOfInterfaces)
{
    RETURN(LvSystemGetNumberOfInterfaces (m_hSystem, pdwNumberOfInterfaces));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvSystem::GetInterfaceId (uint32_t dwIndex,
                                   std::string& sInterfaceId)
{
    size_t iSize = 0;
    LvStatus TlStatus = LvSystemGetInterfaceIdSize (m_hSystem, dwIndex, &iSize);
    if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
    char* pszText = new char[iSize];
    TlStatus = LvSystemGetInterfaceId (m_hSystem, dwIndex, pszText, iSize);
    sInterfaceId = pszText;
    delete[] pszText;
    RETURN(TlStatus);
}
#endif


LvStatus LvSystem::GetInterfaceId (uint32_t dwIndex, 
                                   char* pszInterfaceId, 
                                   size_t iSize)
{
    RETURN(LvSystemGetInterfaceId (m_hSystem, dwIndex, pszInterfaceId, iSize));
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::GetInterfaceIdSize (uint32_t dwIndex, 
                                       size_t* piSize)
{
    RETURN(LvSystemGetInterfaceIdSize (m_hSystem, dwIndex, piSize));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvSystem::FindInterface (LvFindBy FindBy, const char* pFindStr,
                                  std::string& sInterfaceId)
{
    char szText[1024];
    LvStatus TlStatus = LvSystemFindInterface (m_hSystem, FindBy, pFindStr, szText, sizeof(szText));
    sInterfaceId = szText;
    RETURN(TlStatus);
}
#endif

LvStatus LvSystem::FindInterface (LvFindBy FindBy, const char* pFindStr,
                                  char* pInterfaceId, size_t Size)
{
    RETURN(LvSystemFindInterface (m_hSystem, FindBy, pFindStr, pInterfaceId, Size));
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::OpenInterface (const char* pszInterfaceId,
                                  LvInterface*& pInterface)
{
    return LvInterface::Open(this, pszInterfaceId, pInterface);
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::CloseInterface (LvInterface*& pInterface)
{
    return LvInterface::Close(pInterface);
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::OpenEvent (LvEventType EventType,
                              LvEvent*& pEvent)

{
    return LvEvent::Open(this, EventType, pEvent);
}

//-----------------------------------------------------------------------------

LvStatus LvSystem::CloseEvent (LvEvent*& pEvent)
{
    return LvEvent::Close(pEvent);
}

//-----------------------------------------------------------------------------

LvHSystem LvSystem::GetHandle()
{
    return m_hSystem;
}

//-----------------------------------------------------------------------------

LvSystem::LvSystem()
{
    m_hSystem = 0;
}

//-----------------------------------------------------------------------------

LvSystem::~LvSystem()
{
}

/*** LvInterface **************************************************************/

LvStatus LvInterface::Open (LvSystem* pSystem, const char* pszInterfaceId, LvInterface*& pInterface)
{
    pInterface = NULL;
    if (pSystem == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHInterface hInterface = 0;
    LvStatus TlStatus = LvInterfaceOpen (pSystem->GetHandle(), pszInterfaceId, &hInterface);
    if (TlStatus == LVSTATUS_OK)
    {
        pInterface = new LvInterface();
        pInterface->m_hInterface = hInterface;
        pInterface->m_hModule = hInterface;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvInterface::Close (LvInterface*& pInterface)
{
    if (pInterface == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvInterfaceClose (&pInterface->m_hInterface);
    if (TlStatus == LVSTATUS_OK)
    {
        delete pInterface;
        pInterface = NULL;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvInterface::UpdateDeviceList (uint32_t Timeout)
{
    RETURN(LvInterfaceUpdateDeviceList (m_hInterface, Timeout));
}

//-----------------------------------------------------------------------------

LvStatus LvInterface::GetNumberOfDevices (uint32_t* pDevices)
{
    RETURN(LvInterfaceGetNumberOfDevices (m_hInterface, pDevices));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvInterface::GetDeviceId (uint32_t Index, std::string& sDeviceId)
{
    size_t iSize = 0;
    LvStatus TlStatus = LvInterfaceGetDeviceIdSize (m_hInterface, Index, &iSize);
    if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
    char* pszText = new char[iSize];
    TlStatus = LvInterfaceGetDeviceId (m_hInterface, Index, pszText, iSize);
    sDeviceId = pszText;
    delete[] pszText;
    RETURN(TlStatus);
}
#endif

LvStatus LvInterface::GetDeviceId (uint32_t Index, char* pszDeviceId, size_t Size)
{
    RETURN(LvInterfaceGetDeviceId (m_hInterface, Index, pszDeviceId, Size));
}

//-----------------------------------------------------------------------------

LvStatus LvInterface::GetDeviceIdSize (uint32_t dwIndex, size_t* piSize)
{
    RETURN(LvInterfaceGetDeviceIdSize (m_hInterface, dwIndex, piSize));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvInterface::FindDevice (LvFindBy FindBy, const char* pFindStr, std::string& sDeviceId)
{
    char szText[1024];
    LvStatus TlStatus = LvInterfaceFindDevice (m_hInterface, FindBy, pFindStr, szText, sizeof(szText));
    sDeviceId = szText;
    RETURN(TlStatus);
}
#endif

LvStatus LvInterface::FindDevice (LvFindBy FindBy, const char* pFindStr,
                                  char* pDeviceId, size_t Size)
{
    RETURN(LvInterfaceFindDevice (m_hInterface, FindBy, pFindStr, pDeviceId, Size));
}

//-----------------------------------------------------------------------------

LvHInterface LvInterface::GetHandle()
{
    return m_hInterface;
}

//-----------------------------------------------------------------------------

LvStatus LvInterface::OpenDevice (const char* pszDeviceId, LvDevice*& pDevice, LvDeviceAccess iAccess)
{
    return LvDevice::Open(this, pszDeviceId, pDevice, iAccess);
}

//-----------------------------------------------------------------------------

LvStatus LvInterface::CloseDevice (LvDevice*& pDevice)
{
    return LvDevice::Close(pDevice);
}

//-----------------------------------------------------------------------------

LvInterface::LvInterface()
{
    m_hInterface = 0;
}

//-----------------------------------------------------------------------------

LvInterface::~LvInterface()
{
}

/*** LvDevice *****************************************************************/

LvStatus LvDevice::Open (LvInterface* pInterface,
                         const char* pszDeviceId,
                         LvDevice*& pDevice,
                         LvDeviceAccess iAccess)
{
    pDevice = NULL;
    if (pInterface == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHDevice hDevice = 0;
    LvStatus TlStatus = LvDeviceOpen (pInterface->GetHandle(), pszDeviceId, &hDevice, iAccess);
    if (TlStatus == LVSTATUS_OK)
    {
        pDevice = new LvDevice();
        pDevice->m_hDevice = hDevice;
        pDevice->m_hModule = hDevice;
    }
    RETURN(TlStatus);
}


//-----------------------------------------------------------------------------

LvStatus LvDevice::Close (LvDevice*& pDevice)
{
    if (pDevice == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvDeviceClose (&pDevice->m_hDevice);
    if (TlStatus == LVSTATUS_OK)
    {
        delete pDevice;
        pDevice = NULL;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::GetNumberOfStreams (uint32_t* pdwNumberOfStreams)
{
    RETURN(LvDeviceGetNumberOfStreams (m_hDevice, pdwNumberOfStreams));
}

//-----------------------------------------------------------------------------

#ifdef LV_USE_STDLIB
LvStatus LvDevice::GetStreamId (uint32_t dwIndex,
                                std::string& sStreamId)
{
    size_t iSize = 0;
    LvStatus TlStatus = LvDeviceGetStreamIdSize (m_hDevice, dwIndex, &iSize);
    if (TlStatus != LVSTATUS_OK || iSize == 0) RETURN(TlStatus);
    char* pszText = new char[iSize];
    TlStatus = LvDeviceGetStreamId (m_hDevice, dwIndex, pszText, iSize);
    sStreamId = pszText;
    delete[] pszText;
    RETURN(TlStatus);
}
#endif

LvStatus LvDevice::GetStreamId (uint32_t dwIndex, 
                                char* pszStreamId, 
                                size_t iSize)
{
    RETURN(LvDeviceGetStreamId (m_hDevice, dwIndex, pszStreamId, iSize));
}


//-----------------------------------------------------------------------------

LvStatus LvDevice::GetStreamIdSize (uint32_t dwIndex, 
                                    size_t* piSize)
{
    RETURN(LvDeviceGetStreamIdSize (m_hDevice, dwIndex, piSize));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::AcquisitionStart (uint32_t Options)
{
    RETURN(LvDeviceAcquisitionStart (m_hDevice, Options));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::AcquisitionStop (uint32_t Options)
{
    RETURN(LvDeviceAcquisitionStop (m_hDevice, Options));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::AcquisitionAbort (uint32_t Options)
{
    RETURN(LvDeviceAcquisitionAbort (m_hDevice, Options));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::AcquisitionArm (uint32_t Options)
{
    RETURN(LvDeviceAcquisitionArm (m_hDevice, Options));
}

//-----------------------------------------------------------------------------
#ifdef SIMPLON_INC_OBSOLETE

    LvStatus LvDevice::SetHwLUT (LvLUTSelector iSelector, 
                                 void* pLUT, 
                                 size_t iSize)
    {
        RETURN(LvDeviceSetHwLUT (m_hDevice, iSelector, pLUT, iSize));
    }

    //-----------------------------------------------------------------------------

    LvStatus LvDevice::GetHwLUT (LvLUTSelector iSelector, 
                                 void* pLUT, 
                                 size_t iSize)
    {
        RETURN(LvDeviceGetHwLUT (m_hDevice, iSelector, pLUT, iSize));
    }

#endif
//-----------------------------------------------------------------------------

LvStatus LvDevice::SaveSettings (const char* pszId, 
                                 const char* pszFileName,
                                 uint32_t dwOptions)
{
    RETURN(LvDeviceSaveSettings (m_hDevice, pszId, pszFileName, dwOptions));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::LoadSettings (const char* pszId, 
                                 const char* pszFileName,
                                 uint32_t dwOptions)
{
    RETURN(LvDeviceLoadSettings (m_hDevice, pszId, pszFileName, dwOptions));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::LoadBatch (const char* pszFileName)
{
    RETURN(LvDeviceLoadBatch (m_hDevice, pszFileName));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::UniSetLut (LvLUTSelector iSelector, 
                              void* pLUT, 
                              size_t iSize, 
                              uint32_t Options)
{
    RETURN(LvDeviceUniSetLut (m_hDevice, iSelector, pLUT, iSize, Options));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::UniGetLut (LvLUTSelector iSelector, 
                              void* pLUT, 
                              size_t iSize,
                              uint32_t Options)
{
    RETURN(LvDeviceUniGetLut (m_hDevice, iSelector, pLUT, iSize, Options));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::FwGetFilePattern (uint32_t Which,
                                     char* pFilePattern,
                                     size_t Size)
{
    RETURN(LvFwGetFilePattern (m_hDevice, Which, pFilePattern, Size));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::FwLoad (uint32_t Which,
                           const char* pFilePath)
{
    RETURN(LvFwLoad (m_hDevice, Which, pFilePath));
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::FwGetLoadStatus (uint32_t Which,
                                    uint32_t* pCurrentByteCount,
                                    bool* pIsLoading)
{
    uint32_t IsLoading = 0;
    LvStatus TlStatus = LvFwGetLoadStatus (m_hDevice, Which, pCurrentByteCount, &IsLoading);
    if (pIsLoading != NULL) *pIsLoading = IsLoading != 0 ? true : false;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::OpenStream (const char* pszStreamId, 
                               LvStream*& pStream)
{
    return LvStream::Open(this, pszStreamId, pStream);
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::CloseStream (LvStream*& pStream)
{
    return LvStream::Close(pStream);
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::OpenEvent (LvEventType EventType,
                              LvEvent*& pEvent)
{
    return LvEvent::Open(this, EventType, pEvent);
}

//-----------------------------------------------------------------------------

LvStatus LvDevice::CloseEvent (LvEvent*& pEvent)
{
    return LvEvent::Close(pEvent);
}

//-----------------------------------------------------------------------------

LvHDevice LvDevice::GetHandle()
{
    return m_hDevice;
}

//-----------------------------------------------------------------------------

LvDevice::LvDevice()
{
    m_hDevice = 0;
}

//-----------------------------------------------------------------------------

LvDevice::~LvDevice()
{
}

/*** LvStream *****************************************************************/

LvStatus LvStream::Open (LvDevice* pDevice, 
                         const char* pszStreamId, 
                         LvStream*& pStream)
{
    pStream = NULL;
    if (pDevice == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHStream hStream = 0;
    LvStatus TlStatus = LvStreamOpen (pDevice->GetHandle(), pszStreamId, &hStream);
    if (TlStatus == LVSTATUS_OK)
    {
        pStream = new LvStream();
        pStream->m_hStream = hStream;
        pStream->m_hModule = hStream;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::Close (LvStream*& pStream)
{
    if (pStream == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvStreamClose (&pStream->m_hStream);
    if (TlStatus == LVSTATUS_OK)
    {
        delete pStream;
        pStream = NULL;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::GetBufferAt (uint32_t dwBufferIndex, 
                                LvBuffer*& pBuffer)
{
    // userpointer
    LvHBuffer hBuffer;
    LvStatus TlStatus = LvStreamGetBufferAt (m_hStream, dwBufferIndex, &hBuffer);
    if (TlStatus == LVSTATUS_OK)
    {
        LvGetPtr(hBuffer, LvBuffer_UserPtr, (void**)&pBuffer);
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::FlushQueue (LvQueueOperation iOperation)
{
    RETURN(LvStreamFlushQueue (m_hStream, iOperation));
}

//-----------------------------------------------------------------------------

LvStatus LvStream::Start (uint32_t dwStartFlags, 
                          uint32_t dwImagesToAcquire)
{
    RETURN(LvStreamStart (m_hStream, dwStartFlags, dwImagesToAcquire));
}

//-----------------------------------------------------------------------------

LvStatus LvStream::Stop (uint32_t dwStopFlags)
{
    RETURN(LvStreamStop (m_hStream, dwStopFlags));
}

//-----------------------------------------------------------------------------

LvStatus LvStream::OpenBuffer (void* pDataPointer, 
                               size_t DataSize, 
                               void* pUserPointer, 
                               uint32_t Options,
                               LvBuffer*& pBuffer)
{
    return LvBuffer::Open(this, pDataPointer, DataSize, pUserPointer, Options, pBuffer);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::CloseBuffer (LvBuffer*& pBuffer)
{
    return LvBuffer::Close(pBuffer);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::OpenEvent (LvEventType EventType,
                              LvEvent*& pEvent)
{
    return LvEvent::Open(this, EventType, pEvent);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::CloseEvent (LvEvent*& pEvent)
{
    return LvEvent::Close(pEvent);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::OpenRenderer (LvRenderer*& pRenderer)
{
    return LvRenderer::Open(this, pRenderer);
}

//-----------------------------------------------------------------------------

LvStatus LvStream::CloseRenderer (LvRenderer*& pRenderer)
{
    return LvRenderer::Close(pRenderer);
}

//-----------------------------------------------------------------------------

#ifdef LVAVISAVER

    LvStatus LvStream::OpenAviSaver (LvAviSaver*& pAviSaver)
    {
        return LvAviSaver::Open(this, pAviSaver);
    }

    //-----------------------------------------------------------------------------

    LvStatus LvStream::CloseAviSaver (LvAviSaver*& pAviSaver)
    {
        return LvAviSaver::Close(pAviSaver);
    }

#endif

//-----------------------------------------------------------------------------

LvHStream LvStream::GetHandle()
{
    return m_hStream;
}

//-----------------------------------------------------------------------------

LvStream::LvStream()
{
    m_hStream = 0;
}

//-----------------------------------------------------------------------------

LvStream::~LvStream()
{
}

/*** LvBuffer ******************************************************************/

LvStatus LvBuffer::Open (LvStream* pStream, void* pDataPointer, size_t DataSize, void* pUserPointer, uint32_t Options, LvBuffer*& pBuffer)
{
    pBuffer = NULL;
    if (pStream == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHBuffer hBuffer = 0;
    pBuffer = new LvBuffer(); // we use UserPointer to store pBuffer
    LvStatus TlStatus = LvBufferOpen (pStream->GetHandle(), pDataPointer, DataSize, pBuffer, Options, &hBuffer);
    if (TlStatus == LVSTATUS_OK)
    {
        pBuffer->m_hBuffer = hBuffer;
        pBuffer->m_hModule = hBuffer;
        pBuffer->m_pUserPointer = pUserPointer;
    }
    else
        delete pBuffer;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::Close (LvBuffer*& pBuffer)
{
    if (pBuffer == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvBufferClose (&pBuffer->m_hBuffer);
    if (TlStatus == LVSTATUS_OK)
    {
        delete pBuffer;
        pBuffer = NULL;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::AttachProcessBuffer (void* pDataPointer, size_t DataSize)
{
    RETURN(LvBufferAttachProcessBuffer (m_hBuffer, pDataPointer, DataSize));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::Queue ()
{
    RETURN(LvBufferQueue(m_hBuffer));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::ParseChunkData(bool bUpdateLayout)
{
    RETURN(LvBufferParseChunkData(m_hBuffer, bUpdateLayout));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::SaveImageToBmpFile (const char* pszFileName)
{
    RETURN(LvBufferSaveImageToBmpFile(m_hBuffer, pszFileName));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::SaveImageToJpgFile (const char* pszFileName, uint32_t dwQuality)
{
    RETURN(LvBufferSaveImageToJpgFile(m_hBuffer, pszFileName, dwQuality));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::SaveImageToTifFile (const char* pszFileName, uint32_t iOptions)
{
    RETURN(LvBufferSaveImageToTifFile(m_hBuffer, pszFileName, iOptions));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::GetImgInfo (LvipImgInfo& ImgInfo, uint32_t Options)
{
    RETURN(LvBufferGetImgInfo(m_hBuffer, &ImgInfo, Options));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::GetLastPaintRect (int32_t* pX, int32_t* pY, int32_t* pWidth, int32_t* pHeight)
{
    RETURN(LvBufferGetLastPaintRect(m_hBuffer, pX, pY, pWidth, pHeight));
}

//-----------------------------------------------------------------------------

LvStatus LvBuffer::UniCalculateWhiteBalance ()
{
    RETURN(LvBufferUniCalculateWhiteBalance(m_hBuffer));
}

//-----------------------------------------------------------------------------

LvHBuffer LvBuffer::GetHandle()
{
    return m_hBuffer;
}

//-----------------------------------------------------------------------------

void* LvBuffer::GetUserPtr()
{
    return m_pUserPointer;
}

//-----------------------------------------------------------------------------

LvBuffer::LvBuffer()
{
    m_hBuffer = 0;
    m_pUserPointer = NULL;
}

//-----------------------------------------------------------------------------

LvBuffer::~LvBuffer()
{
}

/*** LvEvent ******************************************************************/

LvStatus LvEvent::Open (LvSystem* pSystem,
                        LvEventType EventType,
                        LvEvent*& pEvent)
{
    pEvent = NULL;
    if (pSystem == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHEvent hEvent = 0;
    LvStatus TlStatus = LvEventOpen (pSystem->GetHandle(), EventType, &hEvent);
    if (TlStatus == LVSTATUS_OK)
    {
        pEvent = new LvEvent();
        pEvent->m_hEvent = hEvent;
        pEvent->m_hModule = hEvent;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::Open (LvDevice* pDevice,
                        LvEventType EventType,
                        LvEvent*& pEvent)
{
    pEvent = NULL;
    if (pDevice == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHEvent hEvent = 0;
    LvStatus TlStatus = LvEventOpen (pDevice->GetHandle(), EventType, &hEvent);
    if (TlStatus == LVSTATUS_OK)
    {
        pEvent = new LvEvent();
        pEvent->m_hEvent = hEvent;
        pEvent->m_hModule = hEvent;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::Open (LvStream* pStream,
                        LvEventType EventType,
                        LvEvent*& pEvent)
{
    pEvent = NULL;
    if (pStream == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHEvent hEvent = 0;
    LvStatus TlStatus = LvEventOpen (pStream->GetHandle(), EventType, &hEvent);
    if (TlStatus == LVSTATUS_OK)
    {
        pEvent = new LvEvent();
        pEvent->m_hEvent = hEvent;
        pEvent->m_hModule = hEvent;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::Close (LvEvent*& pEvent)
{
    if (pEvent == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvEventClose (&pEvent->m_hEvent);
    if (TlStatus == LVSTATUS_OK)
    {
        delete pEvent;
        pEvent = NULL;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::Kill ()
{
    RETURN(LvEventKill (m_hEvent));
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::Flush ()
{
    RETURN(LvEventFlush (m_hEvent));
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::WaitAndGetData (void* pBuffer, 
                                  size_t* piSize, 
                                  uint32_t dwTimeout)
{
    RETURN(LvEventWaitAndGetData (m_hEvent, pBuffer, piSize, dwTimeout));
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::WaitAndGetNewBuffer (LvBuffer*& pBuffer, 
                                       uint32_t Timeout)
{
    LvHBuffer hBuffer;
    LvStatus TlStatus = LvEventWaitAndGetNewBuffer (m_hEvent, &hBuffer, Timeout);
    if (TlStatus == LVSTATUS_OK)
    {
        LvGetPtr(hBuffer, LvBuffer_UserPtr, (void**)&pBuffer);
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::GetDataInfo (void* pInBuffer, 
                               size_t iInSize,
                               LvEventDataInfo iInfo,
                               void* pBuffer, 
                               size_t* piSize,
                               LvInfoDataType* piType,
                               int32_t iParam)
{
    LvEnum InfoDataType;
    LvStatus TlStatus = LvEventGetDataInfo (m_hEvent, pInBuffer, iInSize, iInfo, pBuffer, piSize, &InfoDataType, iParam);
    if (piType != NULL) *piType = (LvInfoDataType) InfoDataType;
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::PutData (void* pBuffer, 
                           size_t iSize)
{
    RETURN(LvEventPutData (m_hEvent, pBuffer, iSize));
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::SetCallback (LvEventCallbackFunct pFunction, 
                                     void* pUserParam)
{
    RETURN(LvEventSetCallback (m_hEvent, pFunction, pUserParam));
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::SetCallbackNewBuffer (LvEventCallbackNewBufferFunct pFunction,
                                           void* pUserParam)
{
    RETURN(LvEventSetCallbackNewBuffer (m_hEvent, pFunction, pUserParam));
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::StartThread ()
{
    RETURN(LvEventStartThread (m_hEvent));
}

//-----------------------------------------------------------------------------

LvStatus LvEvent::StopThread  ()
{
    RETURN(LvEventStopThread (m_hEvent));
}

//-----------------------------------------------------------------------------

bool LvEvent::CallbackMustExit()
{
    return LvEventCallbackMustExit(m_hEvent) ? true:false;
}

//-----------------------------------------------------------------------------

LvHEvent LvEvent::GetHandle()
{
    return m_hEvent;
}


//-----------------------------------------------------------------------------

LvEvent::LvEvent()
{
    m_hEvent = 0;
}

//-----------------------------------------------------------------------------

LvEvent::~LvEvent()
{
}

/*** LvRenderer **************************************************************/

LvStatus LvRenderer::Open (LvStream* pStream, LvRenderer*& pRenderer)
{
    pRenderer = NULL;
    if (pStream == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvHRenderer hRenderer = 0;
    LvStatus TlStatus = LvRendererOpen (pStream->GetHandle(), &hRenderer);
    if (TlStatus == LVSTATUS_OK)
    {
        pRenderer = new LvRenderer();
        pRenderer->m_hRenderer = hRenderer;
        pRenderer->m_hModule = hRenderer;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvRenderer::Start (LvRenderer*& pRenderer)
{
    if (pRenderer == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvRendererStart (&pRenderer->m_hRenderer);
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvRenderer::Stop (LvRenderer*& pRenderer)
{
    if (pRenderer == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvRendererStop (&pRenderer->m_hRenderer);
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

LvStatus LvRenderer::Close (LvRenderer*& pRenderer)
{
    if (pRenderer == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
    LvStatus TlStatus = LvRendererClose (&pRenderer->m_hRenderer);
    if (TlStatus == LVSTATUS_OK)
    {
        delete pRenderer;
        pRenderer = NULL;
    }
    RETURN(TlStatus);
}

//-----------------------------------------------------------------------------

#ifdef _WIN32
    LvStatus LvRenderer::SetWindow (HWND hWnd)
    {
        RETURN(LvRendererSetWindow (m_hRenderer, hWnd));
    }
#else
    LvStatus LvRenderer::SetWindow (void* pDisplay,
                                    int64_t hWindow)
    {
        RETURN(LvRendererSetWindow (m_hRenderer, pDisplay, hWindow));
    }
#endif

//-----------------------------------------------------------------------------

LvStatus LvRenderer::DisplayImage (LvBuffer* pBuffer, 
                                   uint32_t dwRenderFlags)
                                    
{
    RETURN(LvRendererDisplayImage (m_hRenderer, pBuffer != NULL ? pBuffer->GetHandle() : 0, dwRenderFlags));
}

//-----------------------------------------------------------------------------

LvStatus LvRenderer::Repaint (uint32_t dwRenderFlags)
{
    RETURN(LvRendererRepaint (m_hRenderer, dwRenderFlags));
}

//-----------------------------------------------------------------------------

LvHRenderer LvRenderer::GetHandle()
{
    return m_hRenderer;
}

//-----------------------------------------------------------------------------

LvRenderer::LvRenderer()
                                    
{
    m_hRenderer = 0;
}

//-----------------------------------------------------------------------------

LvRenderer::~LvRenderer()
                                    
{
}

/*** LvAviSaver **************************************************************/

#ifdef LVAVISAVER

    LvStatus LvAviSaver::Open (LvStream* pStream, LvAviSaver*& pAviSaver)

    {
        pAviSaver = NULL;
        if (pStream == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
        LvHAviSaver hAviSaver = 0;
        LvStatus TlStatus = LvAviSaverOpen (pStream->GetHandle(), &hAviSaver);
        if (TlStatus == LVSTATUS_OK)
        {
            pAviSaver = new LvAviSaver();
            pAviSaver->m_hAviSaver = hAviSaver;
            pAviSaver->m_hModule = hAviSaver;
        }
        RETURN(TlStatus);
    }

    //-----------------------------------------------------------------------------

    LvStatus LvAviSaver::Close (LvAviSaver*& pAviSaver)

    {
        if (pAviSaver == NULL) RETURN(LVSTATUS_PARAMETER_INVALID);
        LvStatus TlStatus = LvAviSaverClose (&pAviSaver->m_hAviSaver);
        if (TlStatus == LVSTATUS_OK)
        {
            delete pAviSaver;
            pAviSaver = NULL;
        }
        RETURN(TlStatus);
    }

    //-----------------------------------------------------------------------------

    LvStatus LvAviSaver::StoreImage (LvBuffer* pBuffer,
                                     uint32_t dwOptions)

    {
        RETURN(LvAviSaverStoreImage (m_hAviSaver, pBuffer->GetHandle(), dwOptions));
    }

    //-----------------------------------------------------------------------------

    LvStatus LvAviSaver::OpenFile (const char* pszName,
                                   uint32_t dwOptions)

    {
        RETURN(LvAviSaverOpenFile (m_hAviSaver, pszName, dwOptions));
    }

    //-----------------------------------------------------------------------------

    LvStatus LvAviSaver::CloseFile ()

    {
        RETURN(LvAviSaverCloseFile (m_hAviSaver));
    }

    //-----------------------------------------------------------------------------

    LvStatus LvAviSaver::SaveSettings (const char* pszId,
                                       const char* pszFileName,
                                       uint32_t dwOptions)

    {
        RETURN(LvAviSaverSaveSettings (m_hAviSaver, pszId, pszFileName, dwOptions));
    }

    //-----------------------------------------------------------------------------

    LvStatus LvAviSaver::LoadSettings (const char* pszId,
                                       const char* pszFileName,
                                       uint32_t dwOptions)

    {
        RETURN(LvAviSaverLoadSettings (m_hAviSaver, pszId, pszFileName, dwOptions));
    }

    //-----------------------------------------------------------------------------

    LvHAviSaver LvAviSaver::GetHandle()
    {
        return m_hAviSaver;
    }

    //-----------------------------------------------------------------------------

    LvAviSaver::LvAviSaver()

    {
        m_hAviSaver = 0;
    }

    //-----------------------------------------------------------------------------

    LvAviSaver::~LvAviSaver()

    {
    }

    //-----------------------------------------------------------------------------

#endif



