
#ifndef ___LV_PCI_DRIVER_IF_H
#define ___LV_PCI_DRIVER_IF_H

#include <linux/ioctl.h>

#define LVSM_DRV_MAGIC "lvsm:-)"

#define LVSM_PCICFG_REPSIZE 256

#define SM_IRQBUF_SIZE 64

typedef struct _sm_dev_info
{
    char DeviceId[16];
    uint32_t  BusNr;
    uint32_t  DevNr;
    uint32_t  FnNr;
    uint8_t PciCfg[LVSM_PCICFG_REPSIZE];
} sm_dev_info;

#define LVSM_ALLDEVS_MAXENTRIES 16

typedef struct _sm_all_devs
{
    uint64_t NrDevs;
    sm_dev_info DevInfo[LVSM_ALLDEVS_MAXENTRIES];
} sm_all_devs;

typedef struct _sm_drv_if
{
    char Magic[8];
    sm_all_devs AllDevs;
} sm_drv_if;

#define LVSM_IOC_MAGIC 0xAB
#define LVSM_IOC_LOCK      _IO(LVSM_IOC_MAGIC, 1)
#define LVSM_IOC_UNLOCK    _IO(LVSM_IOC_MAGIC, 2)
#define LVSM_IOC_IRQMASK   _IO(LVSM_IOC_MAGIC, 3)
#define LVSM_IOC_DMAIDXTBL _IO(LVSM_IOC_MAGIC, 4)
#define LVSM_IOC_MAPAREA   _IO(LVSM_IOC_MAGIC, 5)
#define LVSM_IOC_UNMAPAREA _IO(LVSM_IOC_MAGIC, 6)
#define LVSM_IOC_DUMMYIDX  _IO(LVSM_IOC_MAGIC, 7)

// store the pointers explicitly in 64-bit vars to prevent 32/64 mismatch
typedef struct _sm_page_locks {
    uint64_t Ptr;
    uint64_t NrPages;
    uint64_t DrvId;
    uint64_t PageAddrs;
} sm_page_locks;

typedef struct _sm_irq_info
{
    uint32_t IrqStat;
    uint32_t IrqLoss;
    uint16_t DmaIdx[16];
    uint32_t Reserved[2];
} sm_irq_info;

#define LVSM_IDXTBL_MAXENTRIES   4
#define LVSM_IDXTBL_NOENTRY      0xFFFFFFFF

typedef struct _sm_dma_idx_tbl_entry {
    uint32_t Index;
    uint32_t Value;
} sm_dma_idx_tbl_entry;

typedef struct _sm_dma_idx_tbl {
    uint32_t StreamId;
    uint32_t Offset;
    sm_dma_idx_tbl_entry Entries[LVSM_IDXTBL_MAXENTRIES];
} sm_dma_idx_tbl;

typedef struct _sm_dma_dummy_idx {
    uint32_t StreamId;
    uint32_t Value;
} sm_dma_dummy_idx;

#define LVSM_MEMAREA_MAXENTRIES   2

typedef struct _sm_mem_area {
    uint32_t Offset;
    uint32_t Size;
} sm_mem_area;

#endif
