// ------------------------------------------------------------
//
// sv.explorer script file
//
// ------------------------------------------------------------
//
// The main development target for sv.explorer scripts was to support
// testing of the sv.explorer and the SynView software packet.
// The scripting is somewhat experimentally and may change without further notice.
//
// In the synview explorer sv.explorer a script dialog can be opened by using
// entry "Show script dialog" in the "File" menu.
// Alternatively there is an icon which can be clicked to open the script dialog.
//
// Within the script dialog, a script can be edited, loaded from file, stored into file,
// cleared, executed or stopped. There is also a message window which can be cleared.
//
// Another way to start a scipt is by means of a command line option when starting
// the explorer:
//
// - sv.explorer[.exe] <script file>.exs
//
// ----------------------------------
// Syntax of synview explorer scripts
// ----------------------------------
//
// a) Explorer commands
// --------------------
//
// Explorer commands start with a "#" and are the
// equivalents of the corresponding menu entry.
// The commands are not case sensitive.
//
// There are following commands available:
// - #ConnectCamera <expression> [<variable>]   : opens first matching camera. <expression> should evaluate into string. empty string matches all. if <variable> is given, camera id will be written to it
// - #SelectCamera <expression> [<variable>]    : select an already connected camera. <expression>: camera id string or tab number; if <variable> is given, camera id will be written to it
// - #DisconnectCamera                          : disconnect the selected camera
// - #StartAcquisition                          : start acquisition for the selected camera
// - #StopAcquisition                           : stop acquisition for the selected camera
// - #SendSoftwareTrigger                       : send a software trigger for the selected camera
// - #UpdateCameraList                          : updates the camera list
// - #ControlAllCameras <logical expression>    : select all cameras (valid only for start/stop acquisition and software trigger)
// - #DisplayFullSize                           : display the camera image viewer in unscaled mode
// - #DisplayScaled                             : display the camera image viewer in scaled mode
// - #DisplayTiles                              : display the camera image viewer in tile mode
// - #SaveImage <file> [<nr>]                   : save current image (or buffer nr <nr>; relative addressing with nr<0) to file <file>. <file> should evaluate into string
// - #LoadCameraBatchFile <file>                : load a camera batch file (.svb). <file> is either a string (in quotation marks) or a variable that evaluates into string
// - #ExecuteScript <file>                      : executes an explorer script (.exs - file). <file> is either a string (in quotation marks) or a variable that evaluates into string
//
//
// b) Set variables
// ------------------------------------
//
// - #SetVariable <variable> <expression>       : set variable
//
//
// c) Set/Get camera features
// ----------------------
//
// Following Feature groups are implemented:
// -  LvFtrGroup_DeviceRemote
// -  LvFtrGroup_DeviceLocal
// -  LvFtrGroup_DeviceGtl
// -  LvFtrGroup_RendererLocal
// -  LvFtrGroup_StreamLocal
//
// To set or get camera features, two commands are uses: #SetFeature and #GetFeature.
//
// - #GetFeature <feature> <variable>           : get feature value and store into variable
// - #SetFeature <feature> <expression>         : set feature
// - <feature> <expression>                     : shortcut of #SetFeature <feature> <expression>
//
// These commands address camera features via a feature identifier: <feature>.
// Use the feature string as shown in the "Info" tab of the sv.explorer.
// See under "Set value (generic):" -> "GetFeatureByName" -> parameter nr. 2 -> string in quotation marks.
// For allowed values, see "Set" command in the line below.
//
// Example "Info" tab:
// -  pDevice->GetFeatureByName(LvFtrGroup_DeviceRemote, "RegionSelector", &Ftr_RegionSelector);
// -  pDevice->SetEnumStr(Ftr_RegionSelector, "Region0");
//
// Enum:
// -  RegionSelector "Region0"                  : alternative: RegionSelector 0 is also possible but less clear (0=first entry)
//
// Command:
// -  TriggerSoftware
//
// Further examples
// -  UserSetSelector "UserSet1"
// -  Height 400+20
// -  ExposureTime 500
//
// Getting feature range
// - #GetFeatureMax <feature> <variable>        : get max of feature range and store into variable
// - #GetFeatureMin <feature> <variable>        : get min of feature range and store into variable
// - #GetFeatureInc <feature> <variable>        : get feature increment and store into variable
// - #IsFeatureImplemented <feature> <variable> : if feature is implemented, store 1 into variable
// - #IsFeatureAvailable <feature> <variable>   : if feature is available, store 1 into variable
// - #IsFeatureWritable <feature> <variable>    : if feature is writable, store 1 into variable
// - #IsFeatureReadable <feature> <variable>    : if feature is readable, store 1 into variable
//
// d) Control commands
// -------------------
//
// There are following commands available:
// - #Stop                                      : stop executing current script
// - #Close                                     : stop executing current script and close script window
// - #Exit [<expression>]                       : stop executing current script, close script window and close explorer (only if script is called in cmd line mode). if given, the return code is set to <expression>
// - #Pause <expression>                        : wait for <expression> ms
// - #Goto <Label>                              : goto <Label>
// - :<Label>                                   : Label for goto
// - #If <logical expression>                   : begin of conditional block, block ends with #else or #end
// - #Else                                      : conditional block, executed if corresponding #if was not executed, block ends with #end
// - #While <logical expression>                : begin loop, execute loop body as long as <logical expression> is true
// - #Loop <expression>                         : begin of loop, loop count is determined by <expression>
// - #Break                                     : break of loop (#While or #Loop)
// - #End                                       : closes #If, #While or #Loop
//
//
// e) Message output window control
// --------------------------------
//
// - #Print [<expression>]                      : prints <expression>; string expression will be printed as evaluated, other expressions will be printed in format "<expression> = <result of expression>"
// - #PrintFeature <feature>                    : prints feature, will be printed in format "<feature> = <value of feature>"
// - #MessageClear                              : clears the message output window
// - #MessageStart                              : moves the cursor to the start of the the message output window
// - #MessageEnd                                : moves the cursor to the end of the the message output window
// - #MessageOverwrite <expression>             : enables or disables overwrite mode in message output window (disable: expression>==0)
// - #ShowBuffer <nr>                           : show buffer with allocation order number <buffer> (relative addressing with nr<0: -1 == newest buffer, -2 2nd newest, etc)
// - #CompareImage <var> <file> [<nr>]          : compare current buffer (or buffer nr <nr>; relative addressing with nr<0) to file <file>. Result (Normalized Mean Square Difference) is stored into <var>. if images are different in size, result == 2.0
// - #Log [<expression>]                        : see #Print, but prints expression to the sv.synview.log file
// - #Fopen <file>                              : opens a file for output with "append" file access mode. <file> == string expression (slashes are converted according to OS)
// - #Fclose                                    : closes the file
// - #Fprint <expression>                       : prints <expression> to file; string expression will be printed as evaluated, other expressions will be printed in format "<expression> = <result of expression>"
// - #System <expression> [<variable>]          : executes a system command. result of system command is stored in variable
//
//
// f) Arithmetic operators
// -----------------------
//
//      ~, !        Unary bitwise NOT / logical NOT
//      +, -        Unary Plus and Minus
//      *, /, %     Multiplication, division and remainder
//      +, -        Addition and subtraction
//      <<, >>      shift left, shift right
//      < > <= >=   comparison operators
//      == !=       equality / inequality
//      &           bitwise And
//      ^           bitwise exclusive OR
//      |           bitwise OR
//      &&          logical AND
//      ||          logical OR
//
// All bitwise and shift operators convert their argument to integer values first
//
//
// g) Constants for hex and binary values
// --------------------------------------
//
//      0bzzzzzz    binary z from [0,1]
//      0xzzzzzz    hex z from [0,..9,a,..,f] or [0,..9,A,..,F]
//
//
// h) String operators
// -------------------
//      +           string concatenation
//
//
// i) Functions
// ------------
//
//      floor(<expression>)     :   rounds <expression> downward, returning the largest integral value that is not greater than <expression>
//      rand()                  :   returns a random double number in the range from 0.0 to 1.0
//      seed()                  :   sets an internal random seed for rand () returns seed (call #SetVariable dummy seed())
//      time()                  :   returns current time in ms
//
//      hex$(<expression>)      :   returns the hexadecimal value of <expression> as a string
//      int$(<expression>)      :   returns the integer value of <expression> as a string
//      float$(<expression>)    :   returns the float value of <expression> as a string
//
//      left$(a,l)              :   returns the the leftmost <l> chars from string <a>
//      right$(a,l)             :   returns the the rightmost <l> chars from string <a>
//
//
// ---------------------


// ---------------------
//
// Example script file:
//
// ---------------------
#StopAcquisition

// connect first camera found and remember the camera id string
#ConnectCamera "" CamID
#SelectCamera CamID
#Print "Connected to camera: \"" + CamID + "\""

// or get camera id string by LvDeviceDisplayName
#GetFeature LvDeviceDisplayName CamID
#Print "Camera Device Display Name: " + CamID

#SetVariable vWidth 400
#Print vWidth                                                   // will print: "vWidth = 400.000000"
#PrintFeature Height                                            // will print: "Height = 400.000000"

:Start

// settings
RegionSelector Region0
Height 400
Width vWidth
ExposureTime 500

// print info to message tab
#GetFeature Width vWidth
#GetFeature Height vHeight
#Print "Image Format = 0x" + hex$(vWidth) + " x 0x" + hex$(vHeight)
#Print "Image Format = " + int$(vWidth) + " x " + int$(vHeight)

// start acquisition
#StartAcquisition
#Pause 3000
#StopAcquisition

#SetVariable vWidth vWidth+4

#Goto Start

// ---------------------
